/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.select;

import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.common.Result;
import org.mule.common.metadata.DefinedMapMetaDataModel;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.datatype.DataType;
import org.mule.construct.Flow;
import org.mule.module.db.integration.AbstractDbIntegrationTestCase;
import org.mule.module.db.integration.TestDbConfig;
import org.mule.module.db.integration.model.AbstractTestDatabase;
import org.mule.module.db.internal.processor.AbstractSingleQueryDbMessageProcessor;

public class SelectInputMetadataTestCase
extends AbstractDbIntegrationTestCase {
    public SelectInputMetadataTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        return TestDbConfig.getResources();
    }

    @Override
    protected String[] getFlowConfigurationResources() {
        return new String[]{"integration/select/select-input-metadata-config.xml"};
    }

    @Test
    public void returnsNullSelectMetadataUnParameterizedQuery() throws Exception {
        this.doUnresolvedMetadataTest("selectMetadataNoParams");
    }

    @Test
    public void returnsNullSelectInputMetadataFromNotSupportedParameterizedQuery() throws Exception {
        this.doUnresolvedMetadataTest("selectMetadataNotSupportedValueParams");
    }

    @Test
    public void returnsSelectInputMetadataFromBeanParameterizedQuery() throws Exception {
        this.doResolvedMetadataTest("selectMetadataBeanParams");
    }

    @Test
    public void returnsSelectInputMetadataFromMapParameterizedQuery() throws Exception {
        this.doResolvedMetadataTest("selectMetadataMapParams");
    }

    private void doUnresolvedMetadataTest(String flowName) {
        Flow flowConstruct = (Flow)muleContext.getRegistry().lookupFlowConstruct(flowName);
        List messageProcessors = flowConstruct.getMessageProcessors();
        AbstractSingleQueryDbMessageProcessor queryMessageProcessor = (AbstractSingleQueryDbMessageProcessor)messageProcessors.get(0);
        Result inputMetaData = queryMessageProcessor.getInputMetaData();
        Assert.assertThat((Object)inputMetaData, (Matcher)CoreMatchers.equalTo(null));
    }

    private void doResolvedMetadataTest(String flowName) {
        Flow flowConstruct = (Flow)muleContext.getRegistry().lookupFlowConstruct(flowName);
        List messageProcessors = flowConstruct.getMessageProcessors();
        AbstractSingleQueryDbMessageProcessor queryMessageProcessor = (AbstractSingleQueryDbMessageProcessor)messageProcessors.get(0);
        Result inputMetaData = queryMessageProcessor.getInputMetaData();
        DefinedMapMetaDataModel mapDataModel = (DefinedMapMetaDataModel)((MetaData)inputMetaData.get()).getPayload();
        Assert.assertThat((Object)mapDataModel.getKeys().size(), (Matcher)CoreMatchers.equalTo((Object)2));
        MetaDataModel id = mapDataModel.getValueMetaDataModel("id");
        Assert.assertThat((Object)id.getDataType(), (Matcher)CoreMatchers.equalTo((Object)this.testDatabase.getIdFieldInputMetaDataType()));
        MetaDataModel data = mapDataModel.getValueMetaDataModel("name");
        Assert.assertThat((Object)data.getDataType(), (Matcher)CoreMatchers.equalTo((Object)DataType.STRING));
    }
}

