/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.result.row;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.junit.Test;
import org.mule.module.db.integration.TestRecordUtil;
import org.mule.module.db.integration.model.Field;
import org.mule.module.db.integration.model.Record;
import org.mule.module.db.internal.result.row.InsensitiveMapRowHandler;
import org.mule.module.db.test.util.ColumnMetadata;
import org.mule.module.db.test.util.ResultSetBuilder;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class InsensitiveMapRowHandlerTestCase
extends AbstractMuleTestCase {
    public static final String COLUMN_NAME = "columnName";
    public static final String COLUMN_LABEL = "columnLabel";
    public static final String COLUMN_VALUE = "columnValue";

    @Test
    public void usesColumnLabel() throws Exception {
        ArrayList<ColumnMetadata> columns = new ArrayList<ColumnMetadata>();
        columns.add(new ColumnMetadata(COLUMN_NAME, COLUMN_LABEL, 1));
        ResultSetBuilder resultSetBuilder = new ResultSetBuilder(columns);
        resultSetBuilder.with(Collections.singletonMap(COLUMN_NAME, COLUMN_VALUE));
        ResultSet build = resultSetBuilder.build();
        build.next();
        InsensitiveMapRowHandler rowHandler = new InsensitiveMapRowHandler();
        Map record = rowHandler.process(build);
        TestRecordUtil.assertRecord(new Record(record), new Record(new Field(COLUMN_LABEL, COLUMN_VALUE)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void detectColumnLabelDuplication() throws Exception {
        ArrayList<ColumnMetadata> columns = new ArrayList<ColumnMetadata>();
        columns.add(new ColumnMetadata(COLUMN_NAME, COLUMN_LABEL, 1));
        columns.add(new ColumnMetadata(COLUMN_NAME, COLUMN_LABEL, 2));
        ResultSetBuilder resultSetBuilder = new ResultSetBuilder(columns);
        resultSetBuilder.with(Collections.emptyMap());
        ResultSet build = resultSetBuilder.build();
        build.next();
        InsensitiveMapRowHandler rowHandler = new InsensitiveMapRowHandler();
        rowHandler.process(build);
    }
}

