/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.storedprocedure;

import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.module.db.integration.AbstractDbIntegrationTestCase;
import org.mule.module.db.integration.TestDbConfig;
import org.mule.module.db.integration.model.AbstractTestDatabase;

public class StoredProcedureMultipleParamsTestCase
extends AbstractDbIntegrationTestCase {
    public StoredProcedureMultipleParamsTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        return TestDbConfig.getResources();
    }

    @Override
    protected String[] getFlowConfigurationResources() {
        return new String[]{"integration/storedprocedure/stored-procedure-multi-param-config.xml"};
    }

    @Test
    public void multipliesIntegers() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://multiplyInts", (Object)"Test Message", null);
        Assert.assertThat((Object)response.getPayload(), (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(Map.class)));
        Map payload = (Map)response.getPayload();
        Assert.assertThat((Object)payload.get("result1").toString(), (Matcher)IsEqual.equalTo((Object)"12"));
        Assert.assertThat((Object)payload.get("result2").toString(), (Matcher)IsEqual.equalTo((Object)"60"));
    }

    @Test
    public void concatenatesStrings() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://concatenateStrings", (Object)"Test Message", null);
        Assert.assertThat((Object)response.getPayload(), (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(Map.class)));
        Map payload = (Map)response.getPayload();
        Assert.assertThat((Object)((String)payload.get("result")), (Matcher)IsEqual.equalTo((Object)"foobar"));
    }

    @Before
    public void setupStoredProcedure() throws Exception {
        this.testDatabase.createStoredProcedureMultiplyInts(this.getDefaultDataSource());
        this.testDatabase.createStoredProcedureConcatenateStrings(this.getDefaultDataSource());
    }
}

