/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.storedprocedure;

import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.module.db.integration.AbstractDbIntegrationTestCase;
import org.mule.module.db.integration.TestDbConfig;
import org.mule.module.db.integration.model.AbstractTestDatabase;

public class StoredProcedureOutputParamTestCase
extends AbstractDbIntegrationTestCase {
    public StoredProcedureOutputParamTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        return TestDbConfig.getResources();
    }

    @Override
    protected String[] getFlowConfigurationResources() {
        return new String[]{"integration/storedprocedure/stored-procedure-out-param-config.xml"};
    }

    @Test
    public void testRequestResponse() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://testRequestResponse", (Object)"Test Message", null);
        Assert.assertThat((Object)response.getPayload(), (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(Map.class)));
        Map payload = (Map)response.getPayload();
        Assert.assertThat((Object)"3", (Matcher)CoreMatchers.equalTo((Object)payload.get("count").toString()));
    }

    @Before
    public void setupStoredProcedure() throws Exception {
        this.testDatabase.createStoredProcedureCountRecords(this.getDefaultDataSource());
    }
}

