/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.template;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.module.db.internal.domain.param.InputQueryParam;
import org.mule.module.db.internal.domain.query.QueryTemplate;
import org.mule.module.db.internal.domain.query.QueryType;
import org.mule.module.db.internal.domain.type.UnknownDbType;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.SystemProperty;

public class TemplateQueryConfigTestCase
extends FunctionalTestCase {
    @Rule
    public SystemProperty file = new SystemProperty("file", "integration/template/template-query.sql");
    @Rule
    public SystemProperty query = new SystemProperty("query", "SELECT * FROM PLANET WHERE POSITION = :position");
    @Rule
    public SystemProperty dynamicQuery = new SystemProperty("dynamicQuery", "SELECT * FROM PLANET WHERE POSITION = #[position]");
    @Rule
    public SystemProperty param = new SystemProperty("param", "1");

    protected String getConfigFile() {
        return "integration/template/template-config.xml";
    }

    @Test
    public void definesSelect() throws Exception {
        Object queryTemplateBean = muleContext.getRegistry().get("testSelect");
        Assert.assertTrue((boolean)(queryTemplateBean instanceof QueryTemplate));
        QueryTemplate queryTemplate = (QueryTemplate)queryTemplateBean;
        Assert.assertEquals((Object)QueryType.SELECT, (Object)queryTemplate.getType());
        Assert.assertEquals((Object)"SELECT * FROM PLANET WHERE POSITION = ?", (Object)queryTemplate.getSqlText());
        Assert.assertEquals((long)1L, (long)queryTemplate.getInputParams().size());
        InputQueryParam param1 = (InputQueryParam)queryTemplate.getInputParams().get(0);
        Assert.assertEquals((Object)UnknownDbType.getInstance(), (Object)param1.getType());
        Assert.assertEquals((Object)"position", (Object)param1.getName());
        Assert.assertEquals((Object)"0", (Object)param1.getValue());
        Assert.assertEquals((long)1L, (long)param1.getIndex());
    }

    @Test
    public void definesUpdate() throws Exception {
        Object queryTemplateBean = muleContext.getRegistry().get("testUpdate");
        Assert.assertTrue((boolean)(queryTemplateBean instanceof QueryTemplate));
        QueryTemplate queryTemplate = (QueryTemplate)queryTemplateBean;
        Assert.assertEquals((Object)QueryType.UPDATE, (Object)queryTemplate.getType());
        Assert.assertEquals((Object)"update PLANET set NAME='Mercury' where ID=?", (Object)queryTemplate.getSqlText());
        Assert.assertEquals((long)1L, (long)queryTemplate.getInputParams().size());
        InputQueryParam param1 = (InputQueryParam)queryTemplate.getInputParams().get(0);
        Assert.assertEquals((Object)UnknownDbType.getInstance(), (Object)param1.getType());
        Assert.assertEquals((Object)"id", (Object)param1.getName());
        Assert.assertEquals((Object)"0", (Object)param1.getValue());
        Assert.assertEquals((long)1L, (long)param1.getIndex());
    }

    @Test
    public void readsQueryFromFile() throws Exception {
        this.doQueryFromFileTest(muleContext.getRegistry().get("testFileQuery"), "1");
    }

    @Test
    public void readsParamOverride() throws Exception {
        this.doQueryFromFileTest(muleContext.getRegistry().get("testParamOverride"), "2");
    }

    @Test
    public void readsQueryFromFilePlaceholder() throws Exception {
        this.doQueryFromFileTest(muleContext.getRegistry().get("testFilePlaceholderQuery"), "1");
    }

    @Test
    public void readsQueryPlaceholder() throws Exception {
        this.doQueryFromFileTest(muleContext.getRegistry().get("testPlaceholderQuery"), "1");
    }

    @Test
    public void readsParamPlaceholder() throws Exception {
        this.doQueryFromFileTest(muleContext.getRegistry().get("testPlaceholderParam"), "1");
    }

    @Test
    public void readsQueryFromFileAndEmptyContent() throws Exception {
        this.doQueryFromFileTest(muleContext.getRegistry().get("testFileQueryAndEmptyContent"), "1");
    }

    @Test
    public void usesDynamicQuery() throws Exception {
        Object queryTemplateBean = muleContext.getRegistry().get("testDynamicQuery");
        Assert.assertTrue((boolean)(queryTemplateBean instanceof QueryTemplate));
        QueryTemplate queryTemplate = (QueryTemplate)queryTemplateBean;
        Assert.assertTrue((boolean)queryTemplate.isDynamic());
        Assert.assertEquals((Object)"SELECT * FROM PLANET WHERE POSITION = #[position]", (Object)queryTemplate.getSqlText());
        Assert.assertEquals((long)0L, (long)queryTemplate.getInputParams().size());
    }

    @Test
    public void usesDynamicQueryWithPlaceholder() throws Exception {
        Object queryTemplateBean = muleContext.getRegistry().get("testDynamicPlaceholderQuery");
        Assert.assertTrue((boolean)(queryTemplateBean instanceof QueryTemplate));
        QueryTemplate queryTemplate = (QueryTemplate)queryTemplateBean;
        Assert.assertTrue((boolean)queryTemplate.isDynamic());
        Assert.assertEquals((Object)"SELECT * FROM PLANET WHERE POSITION = #[position]", (Object)queryTemplate.getSqlText());
        Assert.assertEquals((long)0L, (long)queryTemplate.getInputParams().size());
    }

    @Test
    public void usesNullDefaultParamValue() throws Exception {
        Object queryTemplateBean = muleContext.getRegistry().get("testNullParamsQuery");
        QueryTemplate queryTemplate = (QueryTemplate)queryTemplateBean;
        Assert.assertFalse((boolean)queryTemplate.isDynamic());
        Assert.assertEquals((Object)"SELECT * FROM PLANET WHERE POSITION = ?", (Object)queryTemplate.getSqlText());
        Assert.assertEquals((long)1L, (long)queryTemplate.getInputParams().size());
        InputQueryParam param1 = (InputQueryParam)queryTemplate.getInputParams().get(0);
        Assert.assertEquals((Object)UnknownDbType.getInstance(), (Object)param1.getType());
        Assert.assertEquals((Object)"position", (Object)param1.getName());
        Assert.assertEquals(null, (Object)param1.getValue());
        Assert.assertEquals((long)1L, (long)param1.getIndex());
    }

    @Test
    public void overridesDisorderedParams() throws Exception {
        Object queryTemplateBean = muleContext.getRegistry().get("disorderedParams");
        Assert.assertTrue((boolean)(queryTemplateBean instanceof QueryTemplate));
        QueryTemplate queryTemplate = (QueryTemplate)queryTemplateBean;
        Assert.assertEquals((Object)QueryType.SELECT, (Object)queryTemplate.getType());
        Assert.assertEquals((Object)"SELECT * FROM PLANET WHERE POSITION = ? AND NAME = ?", (Object)queryTemplate.getSqlText());
        Assert.assertEquals((long)2L, (long)queryTemplate.getInputParams().size());
        InputQueryParam param1 = (InputQueryParam)queryTemplate.getInputParams().get(0);
        Assert.assertEquals((Object)UnknownDbType.getInstance(), (Object)param1.getType());
        Assert.assertEquals((Object)"position", (Object)param1.getName());
        Assert.assertEquals((Object)"0", (Object)param1.getValue());
        Assert.assertEquals((long)1L, (long)param1.getIndex());
        InputQueryParam param2 = (InputQueryParam)queryTemplate.getInputParams().get(1);
        Assert.assertEquals((Object)UnknownDbType.getInstance(), (Object)param2.getType());
        Assert.assertEquals((Object)"name", (Object)param2.getName());
        Assert.assertEquals((Object)"mars", (Object)param2.getValue());
        Assert.assertEquals((long)2L, (long)param2.getIndex());
    }

    private void doQueryFromFileTest(Object queryTemplateBean, String paramValue) {
        Assert.assertTrue((boolean)(queryTemplateBean instanceof QueryTemplate));
        QueryTemplate queryTemplate = (QueryTemplate)queryTemplateBean;
        Assert.assertEquals((Object)QueryType.SELECT, (Object)queryTemplate.getType());
        Assert.assertEquals((Object)"SELECT * FROM PLANET WHERE POSITION = ?", (Object)queryTemplate.getSqlText());
        Assert.assertEquals((long)1L, (long)queryTemplate.getInputParams().size());
        InputQueryParam param1 = (InputQueryParam)queryTemplate.getInputParams().get(0);
        Assert.assertEquals((Object)UnknownDbType.getInstance(), (Object)param1.getType());
        Assert.assertEquals((Object)"position", (Object)param1.getName());
        Assert.assertEquals((Object)paramValue, (Object)param1.getValue());
        Assert.assertEquals((long)1L, (long)param1.getIndex());
    }
}

