/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.update;

import java.util.List;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.module.db.integration.AbstractDbIntegrationTestCase;
import org.mule.module.db.integration.DbTestUtil;
import org.mule.module.db.integration.TestDbConfig;
import org.mule.module.db.integration.TestRecordUtil;
import org.mule.module.db.integration.matcher.SupportsReturningStoredProcedureResultsWithoutParameters;
import org.mule.module.db.integration.model.AbstractTestDatabase;
import org.mule.module.db.integration.model.DerbyTestDatabase;
import org.mule.module.db.integration.model.Field;
import org.mule.module.db.integration.model.Record;

public class UpdateStoredProcedureTestCase
extends AbstractDbIntegrationTestCase {
    public UpdateStoredProcedureTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        return TestDbConfig.getResources();
    }

    @Override
    protected String[] getFlowConfigurationResources() {
        return new String[]{"integration/update/update-stored-procedure-config.xml"};
    }

    @Test
    public void testRequestResponse() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://updateStoredProcedure", (Object)"Test Message", null);
        int expectedUpdateCount = this.testDatabase instanceof DerbyTestDatabase ? 0 : 1;
        Assert.assertEquals((Object)expectedUpdateCount, (Object)response.getPayload());
        List result = DbTestUtil.selectData("select * from PLANET where POSITION=4", this.getDefaultDataSource());
        TestRecordUtil.assertRecords(result, new Record(new Field("NAME", "Mercury"), new Field("POSITION", 4)));
    }

    @Before
    public void setupStoredProcedure() throws Exception {
        Assume.assumeThat((Object)this.getDefaultDataSource(), (Matcher)new SupportsReturningStoredProcedureResultsWithoutParameters());
        this.testDatabase.createStoredProcedureUpdateTestType1(this.getDefaultDataSource());
    }
}

