/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.domain.database;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.expression.ExpressionManager;
import org.mule.module.db.internal.domain.connection.DbPoolingProfile;
import org.mule.module.db.internal.domain.database.DataSourceConfig;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class DataSourceConfigTestCase
extends AbstractMuleTestCase {
    public static final String MULE_EXPRESSION = "#[expression]";
    public static final String RESOLVED_EXPRESSION = "resolved";
    private final DataSourceConfig dataSourceConfig = new DataSourceConfig();

    @Test
    public void resolvesConfig() throws Exception {
        MuleContext context = (MuleContext)Mockito.mock(MuleContext.class);
        ExpressionManager expressionManager = (ExpressionManager)Mockito.mock(ExpressionManager.class);
        Mockito.when((Object)context.getExpressionManager()).thenReturn((Object)expressionManager);
        MuleEvent muleEvent = (MuleEvent)Mockito.mock(MuleEvent.class);
        DbPoolingProfile poolingProfile = (DbPoolingProfile)Mockito.mock(DbPoolingProfile.class);
        String url = "url";
        String password = "password";
        String user = "user";
        int connectionTimeout = 10;
        String driverClassName = "driverClassName";
        boolean transactionIsolation = true;
        boolean useXaTransactions = true;
        this.dataSourceConfig.setMuleContext(context);
        this.dataSourceConfig.setPoolingProfile(poolingProfile);
        this.dataSourceConfig.setUrl("url");
        this.dataSourceConfig.setPassword("password");
        this.dataSourceConfig.setUser("user");
        this.dataSourceConfig.setConnectionTimeout(10);
        this.dataSourceConfig.setDriverClassName("driverClassName");
        this.dataSourceConfig.setTransactionIsolation(1);
        this.dataSourceConfig.setUseXaTransactions(true);
        DataSourceConfig resolvedDataSourceConfig = this.dataSourceConfig.resolve(muleEvent);
        MatcherAssert.assertThat((Object)resolvedDataSourceConfig.getUrl(), (Matcher)Matchers.equalTo((Object)"url"));
        MatcherAssert.assertThat((Object)resolvedDataSourceConfig.getPassword(), (Matcher)Matchers.equalTo((Object)"password"));
        MatcherAssert.assertThat((Object)resolvedDataSourceConfig.getUser(), (Matcher)Matchers.equalTo((Object)"user"));
        MatcherAssert.assertThat((Object)resolvedDataSourceConfig.getConnectionTimeout(), (Matcher)Matchers.equalTo((Object)10));
        MatcherAssert.assertThat((Object)resolvedDataSourceConfig.getDriverClassName(), (Matcher)Matchers.equalTo((Object)"driverClassName"));
        MatcherAssert.assertThat((Object)resolvedDataSourceConfig.getTransactionIsolation(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)resolvedDataSourceConfig.isUseXaTransactions(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void detectsDynamicUrl() throws Exception {
        this.mockDynamicDataSourceConfigDetection();
        this.dataSourceConfig.setUrl(MULE_EXPRESSION);
        MatcherAssert.assertThat((Object)this.dataSourceConfig.isDynamic(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void detectsDynamicDriverClassName() throws Exception {
        this.mockDynamicDataSourceConfigDetection();
        this.dataSourceConfig.setDriverClassName(MULE_EXPRESSION);
        MatcherAssert.assertThat((Object)this.dataSourceConfig.isDynamic(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void detectsDynamicUser() throws Exception {
        this.mockDynamicDataSourceConfigDetection();
        this.dataSourceConfig.setUser(MULE_EXPRESSION);
        MatcherAssert.assertThat((Object)this.dataSourceConfig.isDynamic(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void detectsDynamicPassword() throws Exception {
        this.mockDynamicDataSourceConfigDetection();
        this.dataSourceConfig.setUser(MULE_EXPRESSION);
        MatcherAssert.assertThat((Object)this.dataSourceConfig.isDynamic(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void resolvesDynamicUrl() throws Exception {
        MuleEvent muleEvent = (MuleEvent)Mockito.mock(MuleEvent.class);
        this.mockDynamicDataSourceConfigEvaluation(muleEvent);
        DataSourceConfig resolvedDataSourceConfig = this.dataSourceConfig.resolve(muleEvent);
        MatcherAssert.assertThat((Object)resolvedDataSourceConfig.getUrl(), (Matcher)Matchers.is((Object)RESOLVED_EXPRESSION));
    }

    @Test
    public void resolvesDynamicDriverClassName() throws Exception {
        MuleEvent muleEvent = (MuleEvent)Mockito.mock(MuleEvent.class);
        this.mockDynamicDataSourceConfigEvaluation(muleEvent);
        this.dataSourceConfig.setDriverClassName(MULE_EXPRESSION);
        DataSourceConfig resolvedDataSourceConfig = this.dataSourceConfig.resolve(muleEvent);
        MatcherAssert.assertThat((Object)resolvedDataSourceConfig.getDriverClassName(), (Matcher)Matchers.is((Object)RESOLVED_EXPRESSION));
    }

    @Test
    public void resolvesDynamicUser() throws Exception {
        MuleEvent muleEvent = (MuleEvent)Mockito.mock(MuleEvent.class);
        this.mockDynamicDataSourceConfigEvaluation(muleEvent);
        this.dataSourceConfig.setUser(MULE_EXPRESSION);
        DataSourceConfig resolvedDataSourceConfig = this.dataSourceConfig.resolve(muleEvent);
        MatcherAssert.assertThat((Object)resolvedDataSourceConfig.getUser(), (Matcher)Matchers.is((Object)RESOLVED_EXPRESSION));
    }

    @Test
    public void resolvesDynamicPassword() throws Exception {
        MuleEvent muleEvent = (MuleEvent)Mockito.mock(MuleEvent.class);
        this.mockDynamicDataSourceConfigEvaluation(muleEvent);
        this.dataSourceConfig.setPassword(MULE_EXPRESSION);
        DataSourceConfig resolvedDataSourceConfig = this.dataSourceConfig.resolve(muleEvent);
        MatcherAssert.assertThat((Object)resolvedDataSourceConfig.getPassword(), (Matcher)Matchers.is((Object)RESOLVED_EXPRESSION));
    }

    private void mockDynamicDataSourceConfigDetection() {
        MuleContext context = (MuleContext)Mockito.mock(MuleContext.class);
        ExpressionManager expressionManager = (ExpressionManager)Mockito.mock(ExpressionManager.class);
        Mockito.when((Object)context.getExpressionManager()).thenReturn((Object)expressionManager);
        Mockito.when((Object)expressionManager.isValidExpression(MULE_EXPRESSION)).thenReturn((Object)true);
        this.dataSourceConfig.setMuleContext(context);
    }

    private void mockDynamicDataSourceConfigEvaluation(MuleEvent muleEvent) {
        ExpressionManager expressionManager = (ExpressionManager)Mockito.mock(ExpressionManager.class);
        MuleContext context = (MuleContext)Mockito.mock(MuleContext.class);
        Mockito.when((Object)context.getExpressionManager()).thenReturn((Object)expressionManager);
        Mockito.when((Object)expressionManager.isValidExpression(MULE_EXPRESSION)).thenReturn((Object)true);
        Mockito.when((Object)expressionManager.parse(MULE_EXPRESSION, muleEvent)).thenReturn((Object)RESOLVED_EXPRESSION);
        this.dataSourceConfig.setMuleContext(context);
        this.dataSourceConfig.setUrl(MULE_EXPRESSION);
    }
}

