/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.config.domain.query;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.mule.module.db.internal.domain.param.AbstractQueryParam;
import org.mule.module.db.internal.domain.param.DefaultInOutQueryParam;
import org.mule.module.db.internal.domain.param.DefaultInputQueryParam;
import org.mule.module.db.internal.domain.param.DefaultOutputQueryParam;
import org.mule.module.db.internal.domain.param.InOutQueryParam;
import org.mule.module.db.internal.domain.param.InputQueryParam;
import org.mule.module.db.internal.domain.param.QueryParam;
import org.mule.module.db.internal.domain.query.QueryTemplate;
import org.mule.module.db.internal.domain.type.DbType;
import org.mule.module.db.internal.domain.type.UnknownDbType;
import org.mule.module.db.internal.parser.QueryTemplateParser;
import org.springframework.beans.factory.FactoryBean;

public class ParameterizedQueryTemplateFactoryBean
implements FactoryBean<QueryTemplate> {
    private final String sqlText;
    private final List<QueryParam> queryParams;
    private final QueryTemplateParser queryParser;

    public ParameterizedQueryTemplateFactoryBean(String sqlText, List<QueryParam> queryParams, QueryTemplateParser queryParser) {
        this.sqlText = sqlText;
        this.queryParams = queryParams;
        this.queryParser = queryParser;
    }

    public QueryTemplate getObject() throws Exception {
        QueryTemplate queryTemplate = this.queryParser.parse(this.sqlText);
        LinkedList<QueryParam> resolvedParams = new LinkedList<QueryParam>();
        LinkedList<QueryParam> unresolvedQueryParams = new LinkedList<QueryParam>(this.queryParams);
        for (QueryParam templateParam : queryTemplate.getParams()) {
            QueryParam param = this.findOverriddenParam(templateParam.getName(), this.queryParams);
            if (param == null) {
                resolvedParams.add(templateParam);
                continue;
            }
            unresolvedQueryParams.remove(param);
            resolvedParams.add(this.overrideParam(templateParam, param));
        }
        if (!unresolvedQueryParams.isEmpty()) {
            throw new IllegalStateException(this.buildUnresolvedParamErrorMsg(unresolvedQueryParams));
        }
        return new QueryTemplate(queryTemplate.getSqlText(), queryTemplate.getType(), resolvedParams);
    }

    private String buildUnresolvedParamErrorMsg(List<QueryParam> unresolvedQueryParams) {
        StringBuilder errorMsgBuilder = new StringBuilder();
        for (QueryParam queryParam : unresolvedQueryParams) {
            if (errorMsgBuilder.length() > 0) {
                errorMsgBuilder.append(", ");
            }
            errorMsgBuilder.append("'").append(queryParam.getName()).append("'");
        }
        errorMsgBuilder.insert(0, "There is at least a query parameter that does not match the name of any parameter defined in the query text. Unresolved parameters: ");
        return errorMsgBuilder.toString();
    }

    private QueryParam overrideParam(QueryParam templateParam, QueryParam queryParam) {
        DbType paramType = templateParam.getType();
        if (!(queryParam.getType() instanceof UnknownDbType)) {
            paramType = queryParam.getType();
        }
        AbstractQueryParam overriddenParam = queryParam instanceof InOutQueryParam ? new DefaultInOutQueryParam(templateParam.getIndex(), paramType, templateParam.getName(), ((InOutQueryParam)queryParam).getValue()) : (queryParam instanceof InputQueryParam ? new DefaultInputQueryParam(templateParam.getIndex(), paramType, ((InputQueryParam)queryParam).getValue(), templateParam.getName()) : new DefaultOutputQueryParam(templateParam.getIndex(), paramType, templateParam.getName()));
        return overriddenParam;
    }

    private QueryParam findOverriddenParam(final String name, List<QueryParam> queryParams) {
        if (name != null) {
            return (QueryParam)CollectionUtils.find(queryParams, (Predicate)new Predicate(){

                public boolean evaluate(Object object) {
                    return name.equals(((QueryParam)object).getName());
                }
            });
        }
        return null;
    }

    public Class<?> getObjectType() {
        return QueryTemplate.class;
    }

    public boolean isSingleton() {
        return false;
    }
}

