/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.processor;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.debug.FieldDebugInfo;
import org.mule.api.debug.FieldDebugInfoFactory;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.domain.executor.BulkExecutor;
import org.mule.module.db.internal.domain.executor.BulkQueryExecutorFactory;
import org.mule.module.db.internal.domain.query.BulkQuery;
import org.mule.module.db.internal.domain.query.Query;
import org.mule.module.db.internal.domain.query.QueryTemplate;
import org.mule.module.db.internal.domain.query.QueryType;
import org.mule.module.db.internal.domain.transaction.TransactionalAction;
import org.mule.module.db.internal.processor.AbstractBulkUpdateMessageProcessor;
import org.mule.module.db.internal.processor.DbDebugInfoUtils;
import org.mule.module.db.internal.resolver.database.DbConfigResolver;
import org.mule.module.db.internal.resolver.query.QueryResolutionException;
import org.mule.module.db.internal.resolver.query.QueryResolver;

public class DynamicBulkUpdateMessageProcessor
extends AbstractBulkUpdateMessageProcessor {
    public DynamicBulkUpdateMessageProcessor(DbConfigResolver dbConfigResolver, QueryResolver queryResolver, BulkQueryExecutorFactory bulkUpdateExecutorFactory, TransactionalAction transactionalAction, List<QueryType> validQueryTypes) {
        super(dbConfigResolver, transactionalAction, validQueryTypes, queryResolver, bulkUpdateExecutorFactory);
    }

    @Override
    protected Object executeQuery(DbConnection connection, MuleEvent muleEvent) throws SQLException {
        BulkQuery bulkQuery = this.resolveBulkQuery(connection, muleEvent);
        BulkExecutor bulkUpdateExecutor = this.bulkUpdateExecutorFactory.create();
        return bulkUpdateExecutor.execute(connection, bulkQuery);
    }

    private BulkQuery resolveBulkQuery(DbConnection connection, MuleEvent muleEvent) {
        Iterator<Object> paramsIterator = this.getIterator(muleEvent);
        BulkQuery bulkQuery = new BulkQuery();
        while (paramsIterator.hasNext()) {
            DefaultMuleMessage itemMessage = new DefaultMuleMessage(paramsIterator.next(), this.muleContext);
            DefaultMuleEvent itemEvent = new DefaultMuleEvent((MuleMessage)itemMessage, muleEvent);
            Query query = this.queryResolver.resolve(connection, (MuleEvent)itemEvent);
            bulkQuery.add(query.getQueryTemplate());
        }
        return bulkQuery;
    }

    @Override
    protected List<FieldDebugInfo<?>> getMessageProcessorDebugInfo(DbConnection connection, MuleEvent muleEvent) {
        BulkQuery bulkQuery;
        MuleEvent eventToUse = this.resolveSource(muleEvent);
        ArrayList fields = new ArrayList();
        try {
            bulkQuery = this.resolveBulkQuery(connection, eventToUse);
        }
        catch (QueryResolutionException e) {
            fields.add((FieldDebugInfo<?>)FieldDebugInfoFactory.createFieldDebugInfo((String)"Queries", List.class, (Exception)e));
            return fields;
        }
        ArrayList<FieldDebugInfo> queries = new ArrayList<FieldDebugInfo>();
        int queryIndex = 1;
        for (QueryTemplate queryTemplate : bulkQuery.getQueryTemplates()) {
            String name = "Query" + queryIndex++;
            FieldDebugInfo queryFieldDebugInfo = DbDebugInfoUtils.createQueryFieldDebugInfo(name, queryTemplate);
            queries.add(queryFieldDebugInfo);
        }
        fields.add((FieldDebugInfo<?>)FieldDebugInfoFactory.createFieldDebugInfo((String)"Queries", List.class, queries));
        return fields;
    }
}

