/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.reconnect;

import java.util.List;
import org.enhydra.jdbc.standard.StandardDataSource;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.retry.RetryContext;
import org.mule.api.retry.RetryNotifier;
import org.mule.module.db.integration.AbstractDbIntegrationTestCase;
import org.mule.module.db.integration.TestDbConfig;
import org.mule.module.db.integration.TestRecordUtil;
import org.mule.module.db.integration.model.AbstractTestDatabase;
import org.mule.module.db.internal.domain.database.DbConfig;
import org.mule.module.db.internal.resolver.database.DbConfigResolver;

public class ReconnectStandardTestCase
extends AbstractDbIntegrationTestCase {
    public static final int EXPECTED_CONNECTION_ERRORS = 2;
    private static int errorCount;

    public ReconnectStandardTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        return TestDbConfig.getDerbyResource();
    }

    @Override
    protected String[] getFlowConfigurationResources() {
        return new String[]{"integration/reconnect/derby-db-reconnect-standard-config.xml"};
    }

    @Test
    public void reconnectsAfterConnectionFailure() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://testReconnection", (Object)"Test Message", null);
        TestRecordUtil.assertMessageContains(response, TestRecordUtil.getAllPlanetRecords());
        Assert.assertThat((Object)errorCount, (Matcher)IsEqual.equalTo((Object)2));
    }

    public static class EnableDatabaseConnection
    implements RetryNotifier {
        public synchronized void onFailure(RetryContext context, Throwable e) {
            errorCount++;
            if (errorCount == 2) {
                DbConfigResolver dbConfigResolver = (DbConfigResolver)muleContext.getRegistry().get("badDbConfig");
                DbConfig config = dbConfigResolver.resolve(null);
                StandardDataSource dataSource = (StandardDataSource)config.getDataSource();
                dataSource.setUrl("jdbc:derby:muleEmbeddedDB;create=true");
            }
        }

        public void onSuccess(RetryContext context) {
        }
    }
}

