/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.select;

import java.util.ArrayList;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.common.Result;
import org.mule.common.metadata.DefaultListMetaDataModel;
import org.mule.common.metadata.DefinedMapMetaDataModel;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.datatype.DataType;
import org.mule.construct.Flow;
import org.mule.module.db.integration.AbstractDbIntegrationTestCase;
import org.mule.module.db.integration.TestDbConfig;
import org.mule.module.db.integration.model.AbstractTestDatabase;
import org.mule.module.db.internal.processor.AbstractSingleQueryDbMessageProcessor;
import org.mule.module.db.internal.result.resultset.ResultSetIterator;

public class SelectOutputMetadataTestCase
extends AbstractDbIntegrationTestCase {
    public SelectOutputMetadataTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        return TestDbConfig.getResources();
    }

    @Override
    protected String[] getFlowConfigurationResources() {
        return new String[]{"integration/select/select-output-metadata-config.xml"};
    }

    @Test
    public void returnsSelectOutputMetadata() throws Exception {
        this.doSelectMetadataTest("selectMetadata", ArrayList.class.getName());
    }

    @Test
    public void returnsSelectStreamingOutputMetadata() throws Exception {
        this.doSelectMetadataTest("selectStreamingMetadata", ResultSetIterator.class.getName());
    }

    private void doSelectMetadataTest(String flowName, String implementationClass) {
        Flow flowConstruct = (Flow)muleContext.getRegistry().lookupFlowConstruct(flowName);
        List messageProcessors = flowConstruct.getMessageProcessors();
        AbstractSingleQueryDbMessageProcessor queryMessageProcessor = (AbstractSingleQueryDbMessageProcessor)messageProcessors.get(0);
        Result outputMetaData = queryMessageProcessor.getOutputMetaData(null);
        DefaultListMetaDataModel listMetaDataModel = (DefaultListMetaDataModel)((MetaData)outputMetaData.get()).getPayload();
        Assert.assertEquals((Object)implementationClass, (Object)listMetaDataModel.getImplementationClass());
        DefinedMapMetaDataModel mapDataModel = (DefinedMapMetaDataModel)listMetaDataModel.getElementModel();
        Assert.assertThat((Object)mapDataModel.getKeys().size(), (Matcher)CoreMatchers.equalTo((Object)3));
        MetaDataModel id = mapDataModel.getValueMetaDataModel("ID");
        Assert.assertThat((Object)id.getDataType(), (Matcher)CoreMatchers.equalTo((Object)this.testDatabase.getIdFieldOutputMetaDataType()));
        MetaDataModel type = mapDataModel.getValueMetaDataModel("POSITION");
        Assert.assertThat((Object)type.getDataType(), (Matcher)CoreMatchers.equalTo((Object)this.testDatabase.getPositionFieldOutputMetaDataType()));
        MetaDataModel data = mapDataModel.getValueMetaDataModel("NAME");
        Assert.assertThat((Object)data.getDataType(), (Matcher)CoreMatchers.equalTo((Object)DataType.STRING));
    }
}

