/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.select;

import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.module.db.integration.AbstractDbIntegrationTestCase;
import org.mule.module.db.integration.TestDbConfig;
import org.mule.module.db.integration.TestRecordUtil;
import org.mule.module.db.integration.model.AbstractTestDatabase;
import org.mule.module.db.internal.result.resultset.ResultSetIterator;

public class SelectStreamingTestCase
extends AbstractDbIntegrationTestCase {
    public SelectStreamingTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        return TestDbConfig.getResources();
    }

    @Override
    protected String[] getFlowConfigurationResources() {
        return new String[]{"integration/select/select-streaming-config.xml"};
    }

    @Test
    public void streamsRecords() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://selectStreaming", (Object)"Test Message", null);
        Assert.assertThat((Object)response.getPayload(), (Matcher)CoreMatchers.is((Matcher)IsInstanceOf.instanceOf(ResultSetIterator.class)));
        TestRecordUtil.assertRecords(response.getInboundProperty("processedRecords"), TestRecordUtil.getAllPlanetRecords());
    }
}

