/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.storedprocedure;

import java.util.LinkedList;
import org.hamcrest.Matcher;
import org.hamcrest.core.AllOf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.module.db.integration.AbstractDbIntegrationTestCase;
import org.mule.module.db.integration.TestRecordUtil;
import org.mule.module.db.integration.matcher.ContainsMessage;
import org.mule.module.db.integration.model.AbstractTestDatabase;
import org.mule.module.db.integration.model.Planet;

public abstract class AbstractStoredProcedureStreamingReturningResultsetTestCase
extends AbstractDbIntegrationTestCase {
    public AbstractStoredProcedureStreamingReturningResultsetTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Test
    public void testOneWay() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("vm://testOneWay", (Object)"Test Message", null);
        LinkedList<MuleMessage> responses = new LinkedList<MuleMessage>();
        MuleMessage response = client.request("vm://testOut", 5000L);
        responses.add(response);
        response = client.request("vm://testOut", 5000L);
        responses.add(response);
        response = client.request("vm://testOut", 5000L);
        responses.add(response);
        Assert.assertEquals((long)3L, (long)responses.size());
        Assert.assertThat(responses, (Matcher)AllOf.allOf(ContainsMessage.mapPayloadWith("NAME", Planet.MARS.getName()), ContainsMessage.mapPayloadWith("NAME", Planet.EARTH.getName()), ContainsMessage.mapPayloadWith("NAME", Planet.VENUS.getName())));
    }

    @Test
    public void testRequestResponse() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://testRequestResponse", (Object)"Test Message", null);
        TestRecordUtil.assertMessageContains(response, TestRecordUtil.getAllPlanetRecords());
    }

    @Before
    public void setupStoredProcedure() throws Exception {
        this.testDatabase.createStoredProcedureGetRecords(this.getDefaultDataSource());
    }
}

