/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.storedprocedure;

import org.junit.Assert;
import org.junit.Test;
import org.mule.module.db.internal.domain.param.InputQueryParam;
import org.mule.module.db.internal.domain.query.QueryTemplate;
import org.mule.module.db.internal.domain.query.QueryType;
import org.mule.module.db.internal.domain.type.UnknownDbType;
import org.mule.tck.junit4.FunctionalTestCase;

public class StoredProcedureTemplateSqlTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "integration/storedprocedure/stored-procedure-template-query-config.xml";
    }

    @Test
    public void configuresSimpleStoredProcedure() throws Exception {
        Object queryTemplateBean = muleContext.getRegistry().get("simple");
        Assert.assertTrue((boolean)(queryTemplateBean instanceof QueryTemplate));
        QueryTemplate queryTemplate = (QueryTemplate)queryTemplateBean;
        Assert.assertEquals((Object)QueryType.STORE_PROCEDURE_CALL, (Object)queryTemplate.getType());
        Assert.assertEquals((long)0L, (long)queryTemplate.getInputParams().size());
    }

    @Test
    public void configuresInputParam() throws Exception {
        Object queryTemplateBean = muleContext.getRegistry().get("inputParam");
        Assert.assertTrue((boolean)(queryTemplateBean instanceof QueryTemplate));
        QueryTemplate queryTemplate = (QueryTemplate)queryTemplateBean;
        Assert.assertEquals((Object)QueryType.STORE_PROCEDURE_CALL, (Object)queryTemplate.getType());
        Assert.assertEquals((long)1L, (long)queryTemplate.getInputParams().size());
        InputQueryParam inputSqlParam = (InputQueryParam)queryTemplate.getInputParams().get(0);
        Assert.assertEquals((Object)UnknownDbType.getInstance(), (Object)inputSqlParam.getType());
        Assert.assertEquals((Object)"foo", (Object)inputSqlParam.getValue());
    }
}

