/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.processor;

import java.sql.SQLException;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.api.MuleEvent;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.domain.connection.DbConnectionFactory;
import org.mule.module.db.internal.domain.database.DbConfig;
import org.mule.module.db.internal.domain.query.QueryType;
import org.mule.module.db.internal.domain.transaction.TransactionalAction;
import org.mule.module.db.internal.processor.AbstractSingleQueryDbMessageProcessor;
import org.mule.module.db.internal.resolver.database.DbConfigResolver;
import org.mule.module.db.internal.resolver.database.UnresolvableDbConfigException;
import org.mule.module.db.internal.resolver.query.QueryResolutionException;
import org.mule.module.db.internal.resolver.query.QueryResolver;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.matcher.FieldDebugInfoMatcher;

public abstract class AbstractSingleQueryMessageProcessorDebugInfoTestCase
extends AbstractMuleTestCase {
    protected final MuleEvent event = (MuleEvent)Mockito.mock(MuleEvent.class);
    protected final DbConnection connection = (DbConnection)Mockito.mock(DbConnection.class);
    protected final DbConnectionFactory dbConnectionFactory = (DbConnectionFactory)Mockito.mock(DbConnectionFactory.class);
    protected final DbConfigResolver dbConfigResolver = (DbConfigResolver)Mockito.mock(DbConfigResolver.class);
    protected final DbConfig dbConfig = (DbConfig)Mockito.mock(DbConfig.class);
    protected final QueryResolver queryResolver = (QueryResolver)Mockito.mock(QueryResolver.class);

    @Test
    public void returnsErrorDebugInfoWhenCannotResolveConfig() throws Exception {
        UnresolvableDbConfigException connectionErrorDebugInfo = new UnresolvableDbConfigException("Error");
        Mockito.when((Object)this.dbConfigResolver.resolve(this.event)).thenThrow(new Throwable[]{connectionErrorDebugInfo});
        AbstractSingleQueryDbMessageProcessor processor = this.createMessageProcessor();
        List debugInfo = processor.getDebugInfo(this.event);
        MatcherAssert.assertThat((Object)debugInfo.size(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)debugInfo, (Matcher)Matchers.hasItem((Matcher)FieldDebugInfoMatcher.fieldLike((String)"Config", DbConfig.class, (Object)connectionErrorDebugInfo)));
    }

    @Test
    public void returnsErrorDebugInfoWhenCannotObtainConnection() throws Exception {
        SQLException debugInfoError = new SQLException();
        Mockito.when((Object)this.dbConnectionFactory.createConnection(TransactionalAction.NOT_SUPPORTED)).thenThrow(new Throwable[]{debugInfoError});
        Mockito.when((Object)this.dbConfigResolver.resolve(this.event)).thenReturn((Object)this.dbConfig);
        Mockito.when((Object)this.dbConfig.getConnectionFactory()).thenReturn((Object)this.dbConnectionFactory);
        AbstractSingleQueryDbMessageProcessor processor = this.createMessageProcessor();
        List debugInfo = processor.getDebugInfo(this.event);
        MatcherAssert.assertThat((Object)debugInfo.size(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)debugInfo, (Matcher)Matchers.hasItem((Matcher)FieldDebugInfoMatcher.fieldLike((String)"Connection", DbConnection.class, (Object)debugInfoError)));
    }

    @Test
    public void returnsErrorDebugInfoWhenCannotResolveQuery() throws Exception {
        Mockito.when((Object)this.dbConnectionFactory.createConnection(TransactionalAction.NOT_SUPPORTED)).thenReturn((Object)this.connection);
        Mockito.when((Object)this.dbConfigResolver.resolve(this.event)).thenReturn((Object)this.dbConfig);
        Mockito.when((Object)this.dbConfig.getConnectionFactory()).thenReturn((Object)this.dbConnectionFactory);
        QueryResolutionException resolutionException = new QueryResolutionException("Error");
        Mockito.when((Object)this.queryResolver.resolve(this.connection, this.event)).thenThrow(new Throwable[]{resolutionException});
        AbstractSingleQueryDbMessageProcessor processor = this.createMessageProcessor();
        List debugInfo = processor.getDebugInfo(this.event);
        MatcherAssert.assertThat((Object)debugInfo.size(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)debugInfo, (Matcher)Matchers.hasItem((Matcher)FieldDebugInfoMatcher.fieldLike((String)"SQL", String.class, (Object)resolutionException)));
    }

    protected abstract AbstractSingleQueryDbMessageProcessor createMessageProcessor();

    protected abstract String getSqlText();

    protected abstract QueryType getQueryType();
}

