/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.processor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.debug.FieldDebugInfo;
import org.mule.module.db.integration.model.Planet;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.domain.connection.DbConnectionFactory;
import org.mule.module.db.internal.domain.database.DbConfig;
import org.mule.module.db.internal.domain.param.DefaultInputQueryParam;
import org.mule.module.db.internal.domain.query.Query;
import org.mule.module.db.internal.domain.query.QueryParamValue;
import org.mule.module.db.internal.domain.query.QueryTemplate;
import org.mule.module.db.internal.domain.query.QueryType;
import org.mule.module.db.internal.domain.transaction.TransactionalAction;
import org.mule.module.db.internal.processor.PreparedBulkUpdateMessageProcessor;
import org.mule.module.db.internal.resolver.database.DbConfigResolver;
import org.mule.module.db.internal.resolver.param.ParamValueResolver;
import org.mule.module.db.internal.resolver.query.QueryResolver;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.matcher.FieldDebugInfoMatcher;
import org.mule.tck.junit4.matcher.ObjectDebugInfoMatcher;
import org.mule.tck.size.SmallTest;

@SmallTest
public class PreparedBulkUpdateMessageProcessorDebugInfoTestCase
extends AbstractMuleTestCase {
    public static final String QUERY_SQL = "update PLANET set NAME='Mercury' where NAME=?";
    public static final QueryTemplate QUERY_TEMPLATE_WITH_NAMED_PARAM = new QueryTemplate("update PLANET set NAME='Mercury' where NAME=?", QueryType.UPDATE, Collections.singletonList(new DefaultInputQueryParam(1, null, null)));
    public static final String PARAM1 = "param 1";
    public static final String PARAM_SET1 = "Param set 1";
    public static final String PARAM_SET2 = "Param set 2";
    private final MuleEvent event = (MuleEvent)Mockito.mock(MuleEvent.class);
    private final MuleMessage message = (MuleMessage)Mockito.mock(MuleMessage.class);
    private final DbConnection connection = (DbConnection)Mockito.mock(DbConnection.class);
    private final DbConnectionFactory dbConnectionFactory = (DbConnectionFactory)Mockito.mock(DbConnectionFactory.class);
    private final DbConfigResolver dbConfigResolver = (DbConfigResolver)Mockito.mock(DbConfigResolver.class);
    private final DbConfig dbConfig = (DbConfig)Mockito.mock(DbConfig.class);
    private final QueryResolver queryResolver = (QueryResolver)Mockito.mock(QueryResolver.class);
    private final MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);

    @Test
    public void returnDebugInfo() throws Exception {
        ArrayList<String> planetNames = new ArrayList<String>();
        planetNames.add(Planet.EARTH.getName());
        planetNames.add(Planet.MARS.getName());
        Mockito.when((Object)this.message.getPayload()).thenReturn(planetNames);
        Mockito.when((Object)this.event.getMessage()).thenReturn((Object)this.message);
        Mockito.when((Object)this.dbConnectionFactory.createConnection(TransactionalAction.NOT_SUPPORTED)).thenReturn((Object)this.connection);
        Mockito.when((Object)this.dbConfigResolver.resolve(this.event)).thenReturn((Object)this.dbConfig);
        Mockito.when((Object)this.dbConfig.getConnectionFactory()).thenReturn((Object)this.dbConnectionFactory);
        Mockito.when((Object)this.queryResolver.resolve((DbConnection)org.mockito.Matchers.argThat((Matcher)Matchers.equalTo((Object)this.connection)), (MuleEvent)org.mockito.Matchers.any(MuleEvent.class))).thenReturn((Object)new Query(QUERY_TEMPLATE_WITH_NAMED_PARAM));
        ParamValueResolver paramValueResolver = (ParamValueResolver)Mockito.mock(ParamValueResolver.class);
        Mockito.when((Object)paramValueResolver.resolveParams((MuleEvent)org.mockito.Matchers.any(MuleEvent.class), (List)org.mockito.Matchers.any(List.class))).thenReturn(Collections.singletonList(new QueryParamValue(null, (Object)Planet.EARTH.getName()))).thenReturn(Collections.singletonList(new QueryParamValue(null, (Object)Planet.MARS.getName())));
        PreparedBulkUpdateMessageProcessor processor = new PreparedBulkUpdateMessageProcessor(this.dbConfigResolver, this.queryResolver, null, TransactionalAction.NOT_SUPPORTED, Collections.singletonList(QueryType.UPDATE), paramValueResolver);
        processor.setMuleContext(this.muleContext);
        List debugInfo = processor.getDebugInfo(this.event);
        MatcherAssert.assertThat((Object)debugInfo.size(), (Matcher)Matchers.equalTo((Object)2));
        ArrayList<Matcher> fieldMatchers = new ArrayList<Matcher>();
        fieldMatchers.add(FieldDebugInfoMatcher.fieldLike((String)"SQL", String.class, (Object)QUERY_SQL));
        fieldMatchers.add(FieldDebugInfoMatcher.fieldLike((String)"Type", String.class, (Object)QueryType.UPDATE.toString()));
        MatcherAssert.assertThat((Object)debugInfo, (Matcher)Matchers.hasItem((Matcher)ObjectDebugInfoMatcher.objectLike((String)"Query", Query.class, fieldMatchers)));
        MatcherAssert.assertThat((Object)debugInfo, (Matcher)Matchers.hasItem((Matcher)ObjectDebugInfoMatcher.objectLike((String)"Input params", List.class, this.createExpectedParamSetMatchers())));
    }

    private List<Matcher<FieldDebugInfo<?>>> createExpectedParamSetMatchers() {
        ArrayList paramSets = new ArrayList();
        ArrayList<Matcher> paramSet1 = new ArrayList<Matcher>();
        paramSet1.add(FieldDebugInfoMatcher.fieldLike((String)PARAM1, String.class, (Object)Planet.EARTH.getName()));
        paramSets.add(ObjectDebugInfoMatcher.objectLike((String)PARAM_SET1, List.class, paramSet1));
        ArrayList<Matcher> paramSet2 = new ArrayList<Matcher>();
        paramSet2.add(FieldDebugInfoMatcher.fieldLike((String)PARAM1, String.class, (Object)Planet.MARS.getName()));
        paramSets.add(ObjectDebugInfoMatcher.objectLike((String)PARAM_SET2, List.class, paramSet2));
        return paramSets;
    }
}

