/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.resolver.database;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.api.MuleEvent;
import org.mule.common.Result;
import org.mule.common.TestResult;
import org.mule.common.metadata.MetaDataKey;
import org.mule.module.db.internal.domain.database.DbConfig;
import org.mule.module.db.internal.resolver.database.ConfiguredDbConfigResolver;
import org.mule.module.db.internal.resolver.database.DbConfigResolver;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class ConfiguredDbConfigResolverTestCase
extends AbstractMuleTestCase {
    private DbConfigResolver dbConfigResolver = (DbConfigResolver)Mockito.mock(DbConfigResolver.class);
    private ConfiguredDbConfigResolver configuredDbConfigResolver = new ConfiguredDbConfigResolver(this.dbConfigResolver);
    private DbConfig dbConfig = (DbConfig)Mockito.mock(DbConfig.class);

    @Test
    public void resolvesDbConfig() throws Exception {
        MuleEvent muleEvent = (MuleEvent)Mockito.mock(MuleEvent.class);
        Mockito.when((Object)this.dbConfigResolver.resolve(muleEvent)).thenReturn((Object)this.dbConfig);
        DbConfig resolvedDbConfig = this.configuredDbConfigResolver.resolve(muleEvent);
        MatcherAssert.assertThat((Object)resolvedDbConfig, (Matcher)Is.is((Object)this.dbConfig));
    }

    @Test
    public void testsConnection() throws Exception {
        TestResult expectedTestResult = (TestResult)Mockito.mock(TestResult.class);
        Mockito.when((Object)this.dbConfig.test()).thenReturn((Object)expectedTestResult);
        Mockito.when((Object)this.dbConfigResolver.resolve(null)).thenReturn((Object)this.dbConfig);
        TestResult testResult = this.configuredDbConfigResolver.test();
        MatcherAssert.assertThat((Object)testResult, (Matcher)Is.is((Object)expectedTestResult));
    }

    @Test
    public void returnsMetaDataKeys() throws Exception {
        Result expectedMetaDataResult = (Result)Mockito.mock(Result.class);
        Mockito.when((Object)this.dbConfig.getMetaDataKeys()).thenReturn((Object)expectedMetaDataResult);
        Mockito.when((Object)this.dbConfigResolver.resolve(null)).thenReturn((Object)this.dbConfig);
        Result metaDataResult = this.configuredDbConfigResolver.getMetaDataKeys();
        MatcherAssert.assertThat((Object)metaDataResult, (Matcher)Is.is((Object)expectedMetaDataResult));
    }

    @Test
    public void returnsMetaData() throws Exception {
        Result expectedMetaData = (Result)Mockito.mock(Result.class);
        MetaDataKey metaDataKey = (MetaDataKey)Mockito.mock(MetaDataKey.class);
        Mockito.when((Object)this.dbConfig.getMetaData(metaDataKey)).thenReturn((Object)expectedMetaData);
        Mockito.when((Object)this.dbConfigResolver.resolve(null)).thenReturn((Object)this.dbConfig);
        Result metaData = this.configuredDbConfigResolver.getMetaData(metaDataKey);
        MatcherAssert.assertThat((Object)metaData, (Matcher)Is.is((Object)expectedMetaData));
    }
}

