/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.processor;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.debug.FieldDebugInfo;
import org.mule.api.debug.FieldDebugInfoFactory;
import org.mule.api.debug.ObjectFieldDebugInfo;
import org.mule.api.debug.SimpleFieldDebugInfo;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.domain.executor.BulkExecutor;
import org.mule.module.db.internal.domain.executor.BulkQueryExecutorFactory;
import org.mule.module.db.internal.domain.query.Query;
import org.mule.module.db.internal.domain.query.QueryParamValue;
import org.mule.module.db.internal.domain.query.QueryType;
import org.mule.module.db.internal.domain.transaction.TransactionalAction;
import org.mule.module.db.internal.processor.AbstractBulkUpdateMessageProcessor;
import org.mule.module.db.internal.processor.DbDebugInfoUtils;
import org.mule.module.db.internal.resolver.database.DbConfigResolver;
import org.mule.module.db.internal.resolver.param.ParamValueResolver;
import org.mule.module.db.internal.resolver.query.QueryResolutionException;
import org.mule.module.db.internal.resolver.query.QueryResolver;

public class PreparedBulkUpdateMessageProcessor
extends AbstractBulkUpdateMessageProcessor {
    private final ParamValueResolver paramValueResolver;

    public PreparedBulkUpdateMessageProcessor(DbConfigResolver dbConfigResolver, QueryResolver queryResolver, BulkQueryExecutorFactory bulkUpdateExecutorFactory, TransactionalAction transactionalAction, List<QueryType> validQueryTypes, ParamValueResolver paramValueResolver) {
        super(dbConfigResolver, transactionalAction, validQueryTypes, queryResolver, bulkUpdateExecutorFactory);
        this.paramValueResolver = paramValueResolver;
    }

    @Override
    protected Object executeQuery(DbConnection connection, MuleEvent muleEvent) throws SQLException {
        Query query = this.queryResolver.resolve(connection, muleEvent);
        this.validateQueryType(query.getQueryTemplate());
        List<List<QueryParamValue>> paramValues = this.resolveParamSets(muleEvent, query);
        BulkExecutor bulkUpdateExecutor = this.bulkUpdateExecutorFactory.create();
        return bulkUpdateExecutor.execute(connection, query, paramValues);
    }

    private List<List<QueryParamValue>> resolveParamSets(MuleEvent muleEvent, Query query) {
        Iterator<Object> paramsIterator = this.getIterator(muleEvent);
        LinkedList<List<QueryParamValue>> result = new LinkedList<List<QueryParamValue>>();
        while (paramsIterator.hasNext()) {
            DefaultMuleMessage itemMessage = new DefaultMuleMessage(paramsIterator.next(), this.muleContext);
            DefaultMuleEvent itemEvent = new DefaultMuleEvent((MuleMessage)itemMessage, muleEvent);
            List<QueryParamValue> queryParamValues = this.paramValueResolver.resolveParams((MuleEvent)itemEvent, query.getParamValues());
            result.add(queryParamValues);
        }
        return result;
    }

    @Override
    protected List<FieldDebugInfo<?>> getMessageProcessorDebugInfo(DbConnection connection, MuleEvent muleEvent) {
        Query resolvedQuery;
        MuleEvent eventToUse = this.resolveSource(muleEvent);
        ArrayList fields = new ArrayList();
        try {
            resolvedQuery = this.queryResolver.resolve(connection, eventToUse);
        }
        catch (QueryResolutionException e) {
            fields.add((FieldDebugInfo<?>)FieldDebugInfoFactory.createFieldDebugInfo((String)"Query", String.class, (Exception)e));
            return fields;
        }
        fields.add(DbDebugInfoUtils.createQueryFieldDebugInfo("Query", resolvedQuery.getQueryTemplate()));
        List<List<QueryParamValue>> paramSets = this.resolveParamSets(muleEvent, resolvedQuery);
        LinkedList<ObjectFieldDebugInfo> paramSetInfos = new LinkedList<ObjectFieldDebugInfo>();
        int setIndex = 1;
        for (List<QueryParamValue> paramSet : paramSets) {
            ArrayList<SimpleFieldDebugInfo> paramFields = new ArrayList<SimpleFieldDebugInfo>();
            int paramIndex = 1;
            for (QueryParamValue paramValue : paramSet) {
                String name = paramValue.getName() == null ? "param " + paramIndex++ : paramValue.getName();
                paramFields.add(FieldDebugInfoFactory.createFieldDebugInfo((String)name, String.class, (Object)paramValue.getValue()));
            }
            paramSetInfos.add(FieldDebugInfoFactory.createFieldDebugInfo((String)("Param set " + setIndex++), List.class, paramFields));
        }
        fields.add((FieldDebugInfo<?>)FieldDebugInfoFactory.createFieldDebugInfo((String)"Input params", List.class, paramSetInfos));
        return fields;
    }
}

