/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.config;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.junit.Before;
import org.junit.runners.Parameterized;
import org.mule.module.db.integration.AbstractDbIntegrationTestCase;
import org.mule.module.db.integration.TestDbConfig;
import org.mule.module.db.integration.model.AbstractTestDatabase;

public abstract class AbstractDatasourcePoolingTestCase
extends AbstractDbIntegrationTestCase {
    protected static final int TOTAL_CONCURRENT_REQUESTS = 2;
    protected static CountDownLatch connectionLatch;

    public AbstractDatasourcePoolingTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        return TestDbConfig.getDerbyResource();
    }

    @Before
    public void setUp() throws Exception {
        connectionLatch = new CountDownLatch(2);
    }

    public static class JoinRequests {
        public static Object process(Object payload) {
            connectionLatch.countDown();
            try {
                connectionLatch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return payload;
        }
    }
}

