/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.domain.type;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.List;
import org.mule.module.db.internal.domain.type.AbstractStructuredDbType;

public class StructDbType
extends AbstractStructuredDbType {
    public StructDbType(int id, String name) {
        super(id, name);
    }

    @Override
    public void setParameterValue(PreparedStatement statement, int index, Object value) throws SQLException {
        if (value != null && !(value instanceof Struct)) {
            Connection connection = statement.getConnection();
            if (value instanceof Object[]) {
                value = connection.createStruct(this.name, (Object[])value);
            } else if (value instanceof List) {
                value = connection.createStruct(this.name, ((List)value).toArray());
            } else {
                throw new IllegalArgumentException(StructDbType.createUnsupportedTypeErrorMessage(value));
            }
        }
        super.setParameterValue(statement, index, value);
    }

    protected static String createUnsupportedTypeErrorMessage(Object value) {
        return String.format("Cannot create a %s from a value of type '%s'", Struct.class.getName(), value.getClass());
    }
}

