/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.delete;

import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.common.Result;
import org.mule.construct.Flow;
import org.mule.module.db.integration.TestDbConfig;
import org.mule.module.db.integration.delete.AbstractUpdateInputMetadataTestCase;
import org.mule.module.db.integration.model.AbstractTestDatabase;
import org.mule.module.db.internal.processor.AbstractSingleQueryDbMessageProcessor;

public class DeleteInputMetadataTestCase
extends AbstractUpdateInputMetadataTestCase {
    public DeleteInputMetadataTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        return TestDbConfig.getResources();
    }

    @Override
    protected String[] getFlowConfigurationResources() {
        return new String[]{"integration/delete/delete-input-metadata-config.xml"};
    }

    @Test
    public void returnsNullDeleteMetadataUnParameterizedQuery() throws Exception {
        this.doUnresolvedMetadataTest("deleteMetadataNoParams");
    }

    @Test
    public void returnsNullDeleteInputMetadataFromNotSupportedParameterizedQuery() throws Exception {
        this.doUnresolvedMetadataTest("deleteMetadataNotSupportedValueParams");
    }

    @Test
    public void returnsDeleteInputMetadataFromBeanParameterizedQuery() throws Exception {
        this.doResolvedMetadataTest("deleteMetadataBeanParams");
    }

    @Test
    public void returnsDeleteInputMetadataFromMapParameterizedQuery() throws Exception {
        this.doResolvedMetadataTest("deleteMetadataMapParams");
    }

    private void doUnresolvedMetadataTest(String flowName) {
        Flow flowConstruct = (Flow)muleContext.getRegistry().lookupFlowConstruct(flowName);
        List messageProcessors = flowConstruct.getMessageProcessors();
        AbstractSingleQueryDbMessageProcessor queryMessageProcessor = (AbstractSingleQueryDbMessageProcessor)messageProcessors.get(0);
        Result inputMetaData = queryMessageProcessor.getInputMetaData();
        Assert.assertThat((Object)inputMetaData, (Matcher)CoreMatchers.equalTo(null));
    }
}

