/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.storedprocedure;

import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.module.db.integration.AbstractDbIntegrationTestCase;
import org.mule.module.db.integration.TestDbConfig;
import org.mule.module.db.integration.TestRecordUtil;
import org.mule.module.db.integration.matcher.SupportsStoredFunctionsUsingCallSyntax;
import org.mule.module.db.integration.model.AbstractTestDatabase;
import org.mule.module.db.internal.result.resultset.ResultSetIterator;
import org.mule.transport.NullPayload;

public class StoredProcedureStreamingResourceManagementTestCase
extends AbstractDbIntegrationTestCase {
    public StoredProcedureStreamingResourceManagementTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        return TestDbConfig.getResources();
    }

    @Override
    protected String[] getFlowConfigurationResources() {
        return new String[]{"integration/config/derby-pooling-db-config.xml", "integration/storedprocedure/stored-procedure-streaming-resource-management-config.xml"};
    }

    @Test
    public void closesConnectionsWhenStatementConsumed() throws Exception {
        this.doSuccessfulMessageTest();
        this.doSuccessfulMessageTest();
        this.doSuccessfulMessageTest();
    }

    private void doSuccessfulMessageTest() throws MuleException {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://storedProcedureStreaming", (Object)"Test Message", null);
        Map payload = (Map)response.getPayload();
        Assert.assertThat((Object)payload.size(), (Matcher)IsEqual.equalTo((Object)1));
        Assert.assertThat(payload.get("resultSet1"), (Matcher)CoreMatchers.is((Matcher)IsInstanceOf.instanceOf(ResultSetIterator.class)));
        Assert.assertThat((Object)response.getInboundProperty("processedResults"), (Matcher)CoreMatchers.is((Matcher)IsInstanceOf.instanceOf(List.class)));
        TestRecordUtil.assertRecords(response.getInboundProperty("processedResults"), TestRecordUtil.getAllPlanetRecords());
    }

    @Test
    public void closesConnectionsOnProcessingError() throws Exception {
        this.doFailedMessageTest();
        this.doFailedMessageTest();
        this.doFailedMessageTest();
    }

    private void doFailedMessageTest() throws MuleException {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://storedProcedureStreamingError", (Object)"Test Message", null);
        Assert.assertThat((Object)response.getExceptionPayload(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)response.getExceptionPayload().getRootException().getMessage(), (Matcher)CoreMatchers.equalTo((Object)"Failing test on purpose"));
        Assert.assertThat((Object)response.getPayload(), (Matcher)CoreMatchers.is((Matcher)IsInstanceOf.instanceOf(NullPayload.class)));
    }

    @Before
    public void setupStoredProcedure() throws Exception {
        Assume.assumeThat((Object)this.getDefaultDataSource(), (Matcher)new SupportsStoredFunctionsUsingCallSyntax());
        this.testDatabase.createStoredProcedureGetRecords(this.getDefaultDataSource());
    }
}

