/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.resolver.database;

import java.util.ArrayList;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.mockito.Mockito;
import org.mule.api.MuleEvent;
import org.mule.api.registry.MuleRegistry;
import org.mule.common.Result;
import org.mule.common.TestResult;
import org.mule.common.metadata.MetaDataKey;
import org.mule.module.db.internal.domain.database.DbConfig;
import org.mule.module.db.internal.resolver.database.DbConfigResolver;
import org.mule.module.db.internal.resolver.database.DefaultDbConfigResolver;
import org.mule.module.db.internal.resolver.database.UnresolvableDbConfigException;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class DefaultDbConfigResolverTestCase
extends AbstractMuleTestCase {
    private final MuleEvent muleEvent = (MuleEvent)Mockito.mock(MuleEvent.class);

    @Test
    public void resolvesDefaultDbConfig() throws Exception {
        DbConfigResolver dbConfigResolver = (DbConfigResolver)Mockito.mock(DbConfigResolver.class);
        DbConfig dbConfig = (DbConfig)Mockito.mock(DbConfig.class);
        Mockito.when((Object)dbConfigResolver.resolve(this.muleEvent)).thenReturn((Object)dbConfig);
        MuleRegistry registry = this.createMockRegistry(dbConfigResolver);
        DefaultDbConfigResolver defaultDbConfigResolver = new DefaultDbConfigResolver(registry);
        DbConfig resolvedDbConfig = defaultDbConfigResolver.resolve(this.muleEvent);
        Assert.assertThat((Object)dbConfig, (Matcher)IsSame.sameInstance((Object)resolvedDbConfig));
    }

    @Test(expected=UnresolvableDbConfigException.class)
    public void throwsErrorWhenNoDbConfigAvailable() throws Exception {
        MuleRegistry registry = (MuleRegistry)Mockito.mock(MuleRegistry.class);
        ArrayList foundDbConfigs = new ArrayList();
        Mockito.when((Object)registry.lookupObjects(DbConfig.class)).thenReturn(foundDbConfigs);
        DefaultDbConfigResolver dbConfigResolver = new DefaultDbConfigResolver(registry);
        dbConfigResolver.resolve(this.muleEvent);
    }

    @Test
    public void throwsErrorWhenMultipleDbConfigAvailable() throws Exception {
        DbConfig dbConfig1 = (DbConfig)Mockito.mock(DbConfig.class);
        Mockito.when((Object)dbConfig1.getName()).thenReturn((Object)"dbConfig1");
        DbConfig dbConfig2 = (DbConfig)Mockito.mock(DbConfig.class);
        Mockito.when((Object)dbConfig2.getName()).thenReturn((Object)"dbConfig2");
        DbConfigResolver dbConfigResolver1 = (DbConfigResolver)Mockito.mock(DbConfigResolver.class);
        Mockito.when((Object)dbConfigResolver1.resolve(null)).thenReturn((Object)dbConfig1);
        DbConfigResolver dbConfigResolver2 = (DbConfigResolver)Mockito.mock(DbConfigResolver.class);
        Mockito.when((Object)dbConfigResolver2.resolve(null)).thenReturn((Object)dbConfig2);
        MuleRegistry registry = (MuleRegistry)Mockito.mock(MuleRegistry.class);
        ArrayList<DbConfigResolver> foundDbConfigResolvers = new ArrayList<DbConfigResolver>();
        foundDbConfigResolvers.add(dbConfigResolver1);
        foundDbConfigResolvers.add(dbConfigResolver2);
        Mockito.when((Object)registry.lookupObjects(DbConfigResolver.class)).thenReturn(foundDbConfigResolvers);
        DefaultDbConfigResolver dbConfigResolver = new DefaultDbConfigResolver(registry);
        try {
            dbConfigResolver.resolve(this.muleEvent);
            Assert.fail((String)"Was supposed to fail when there are multiple dbConfigs available");
        }
        catch (UnresolvableDbConfigException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)JUnitMatchers.containsString((String)"dbConfig1"));
            Assert.assertThat((Object)e.getMessage(), (Matcher)JUnitMatchers.containsString((String)"dbConfig2"));
        }
    }

    @Test
    public void testsConnection() throws Exception {
        DbConfig dbConfig = (DbConfig)Mockito.mock(DbConfig.class);
        TestResult expectedTestResult = (TestResult)Mockito.mock(TestResult.class);
        Mockito.when((Object)dbConfig.test()).thenReturn((Object)expectedTestResult);
        DbConfigResolver dbConfigResolver = (DbConfigResolver)Mockito.mock(DbConfigResolver.class);
        Mockito.when((Object)dbConfigResolver.resolve(null)).thenReturn((Object)dbConfig);
        MuleRegistry registry = this.createMockRegistry(dbConfigResolver);
        DefaultDbConfigResolver defaultDbConfigResolver = new DefaultDbConfigResolver(registry);
        TestResult testResult = defaultDbConfigResolver.test();
        Assert.assertThat((Object)testResult, (Matcher)Is.is((Object)expectedTestResult));
    }

    @Test
    public void returnsMetaDataKeys() throws Exception {
        DbConfig dbConfig = (DbConfig)Mockito.mock(DbConfig.class);
        Result expectedMetaDataResult = (Result)Mockito.mock(Result.class);
        Mockito.when((Object)dbConfig.getMetaDataKeys()).thenReturn((Object)expectedMetaDataResult);
        DbConfigResolver dbConfigResolver = (DbConfigResolver)Mockito.mock(DbConfigResolver.class);
        Mockito.when((Object)dbConfigResolver.resolve(null)).thenReturn((Object)dbConfig);
        MuleRegistry registry = this.createMockRegistry(dbConfigResolver);
        DefaultDbConfigResolver defaultDbConfigResolver = new DefaultDbConfigResolver(registry);
        Result metaDataResult = defaultDbConfigResolver.getMetaDataKeys();
        Assert.assertThat((Object)metaDataResult, (Matcher)Is.is((Object)expectedMetaDataResult));
    }

    @Test
    public void returnsMetaData() throws Exception {
        DbConfig dbConfig = (DbConfig)Mockito.mock(DbConfig.class);
        Result expectedMetaData = (Result)Mockito.mock(Result.class);
        MetaDataKey metaDataKey = (MetaDataKey)Mockito.mock(MetaDataKey.class);
        Mockito.when((Object)dbConfig.getMetaData(metaDataKey)).thenReturn((Object)expectedMetaData);
        DbConfigResolver dbConfigResolver = (DbConfigResolver)Mockito.mock(DbConfigResolver.class);
        Mockito.when((Object)dbConfigResolver.resolve(null)).thenReturn((Object)dbConfig);
        MuleRegistry registry = this.createMockRegistry(dbConfigResolver);
        DefaultDbConfigResolver defaultDbConfigResolver = new DefaultDbConfigResolver(registry);
        Result metaData = defaultDbConfigResolver.getMetaData(metaDataKey);
        Assert.assertThat((Object)metaData, (Matcher)Is.is((Object)expectedMetaData));
    }

    private MuleRegistry createMockRegistry(DbConfigResolver dbConfigResolver) {
        ArrayList<DbConfigResolver> foundDbConfigResolvers = new ArrayList<DbConfigResolver>();
        foundDbConfigResolvers.add(dbConfigResolver);
        MuleRegistry registry = (MuleRegistry)Mockito.mock(MuleRegistry.class);
        Mockito.when((Object)registry.lookupObjects(DbConfigResolver.class)).thenReturn(foundDbConfigResolvers);
        return registry;
    }
}

