/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.result.statement;

import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.domain.query.QueryTemplate;
import org.mule.module.db.internal.domain.query.QueryType;
import org.mule.module.db.internal.result.statement.GenericStatementResultIteratorFactory;
import org.mule.module.db.internal.result.statement.StatementResultIterator;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class GenericStatementResultIteratorFactoryTestCase
extends AbstractMuleTestCase {
    private final GenericStatementResultIteratorFactory resultIteratorFactory = new GenericStatementResultIteratorFactory(null);
    private final Statement statement = (Statement)Mockito.mock(CallableStatement.class);

    @Test(expected=IllegalArgumentException.class)
    public void createsIterator() throws Exception {
        DbConnection connection = this.createMockConnection(true);
        StatementResultIterator statementResultIterator = this.resultIteratorFactory.create(connection, this.statement, new QueryTemplate(null, QueryType.STORE_PROCEDURE_CALL, Collections.emptyList()), null);
        MatcherAssert.assertThat((Object)statementResultIterator, (Matcher)IsInstanceOf.instanceOf(StatementResultIterator.class));
    }

    private DbConnection createMockConnection(boolean supportsMultipleOpenResults) throws SQLException {
        DbConnection connection = (DbConnection)Mockito.mock(DbConnection.class);
        DatabaseMetaData metaData = (DatabaseMetaData)Mockito.mock(DatabaseMetaData.class);
        Mockito.when((Object)metaData.supportsMultipleOpenResults()).thenReturn((Object)supportsMultipleOpenResults);
        Mockito.when((Object)connection.getMetaData()).thenReturn((Object)metaData);
        return connection;
    }
}

