/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.domain.database;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import javax.xml.namespace.QName;
import org.mule.AbstractAnnotatedObject;
import org.mule.api.MuleContext;
import org.mule.api.NamedObject;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.module.db.internal.domain.connection.AbstractConnectionFactory;
import org.mule.module.db.internal.domain.connection.ConnectionCreationException;
import org.mule.module.db.internal.domain.connection.ConnectionFactory;
import org.mule.module.db.internal.domain.connection.DbConnectionFactory;
import org.mule.module.db.internal.domain.connection.RetryConnectionFactory;
import org.mule.module.db.internal.domain.connection.SimpleConnectionFactory;
import org.mule.module.db.internal.domain.connection.TransactionalDbConnectionFactory;
import org.mule.module.db.internal.domain.database.ConfigurableDbConfigFactory;
import org.mule.module.db.internal.domain.database.DbConfig;
import org.mule.module.db.internal.domain.database.GenericDbConfig;
import org.mule.module.db.internal.domain.transaction.TransactionCoordinationDbTransactionManager;
import org.mule.module.db.internal.domain.type.CompositeDbTypeManager;
import org.mule.module.db.internal.domain.type.DbType;
import org.mule.module.db.internal.domain.type.DbTypeManager;
import org.mule.module.db.internal.domain.type.JdbcTypes;
import org.mule.module.db.internal.domain.type.MetadataDbTypeManager;
import org.mule.module.db.internal.domain.type.StaticDbTypeManager;
import org.mule.retry.policies.NoRetryPolicyTemplate;

public class GenericDbConfigFactory
implements ConfigurableDbConfigFactory {
    private List<DbType> customDataTypes;
    private RetryPolicyTemplate retryPolicyTemplate;
    private MuleContext muleContext;

    @Override
    public DbConfig create(String name, Map<QName, Object> annotations, DataSource dataSource) {
        SimpleConnectionFactory simpleConnectionFactory = new SimpleConnectionFactory();
        if (this.retryPolicyTemplate == null) {
            this.retryPolicyTemplate = this.getDefaultRetryPolicyTemplate();
        }
        AbstractConnectionFactory connectionFactory = this.retryPolicyTemplate == null ? simpleConnectionFactory : new RetryConnectionFactory(this.retryPolicyTemplate, new AnnotatedConnectionFactory(name, simpleConnectionFactory, annotations));
        DbTypeManager dbTypeManager = this.doCreateTypeManager();
        DbConnectionFactory dbConnectionFactory = this.createDbConnectionFactory(dataSource, connectionFactory, dbTypeManager);
        return this.doCreateDbConfig(dataSource, dbTypeManager, dbConnectionFactory, name);
    }

    protected DbConnectionFactory createDbConnectionFactory(DataSource dataSource, ConnectionFactory connectionFactory, DbTypeManager dbTypeManager) {
        return new TransactionalDbConnectionFactory(new TransactionCoordinationDbTransactionManager(), dbTypeManager, connectionFactory, dataSource);
    }

    protected DbConfig doCreateDbConfig(DataSource datasource, DbTypeManager dbTypeManager, DbConnectionFactory dbConnectionFactory, String name) {
        return new GenericDbConfig(datasource, name, dbTypeManager, dbConnectionFactory);
    }

    protected DbTypeManager doCreateTypeManager() {
        List<DbType> vendorDataTypes;
        ArrayList<DbTypeManager> typeManagers = new ArrayList<DbTypeManager>();
        typeManagers.add(new MetadataDbTypeManager());
        if (this.customDataTypes.size() > 0) {
            typeManagers.add(new StaticDbTypeManager(this.customDataTypes));
        }
        if ((vendorDataTypes = this.getVendorDataTypes()).size() > 0) {
            typeManagers.add(new StaticDbTypeManager(vendorDataTypes));
        }
        typeManagers.add(new StaticDbTypeManager(JdbcTypes.types));
        return new CompositeDbTypeManager(typeManagers);
    }

    protected List<DbType> getVendorDataTypes() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public void setCustomDataTypes(List<DbType> customDataTypes) {
        this.customDataTypes = customDataTypes;
    }

    @Override
    public void setRetryPolicyTemplate(RetryPolicyTemplate retryPolicyTemplate) {
        this.retryPolicyTemplate = retryPolicyTemplate;
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    protected RetryPolicyTemplate getDefaultRetryPolicyTemplate() {
        RetryPolicyTemplate retryPolicyTemplate = (RetryPolicyTemplate)this.muleContext.getRegistry().lookupObject("_defaultRetryPolicyTemplate");
        return retryPolicyTemplate instanceof NoRetryPolicyTemplate ? null : retryPolicyTemplate;
    }

    private class AnnotatedConnectionFactory
    extends AbstractAnnotatedObject
    implements ConnectionFactory,
    NamedObject {
        private String name;
        private ConnectionFactory inner;

        public AnnotatedConnectionFactory(String name, ConnectionFactory inner, Map<QName, Object> annotations) {
            this.name = name;
            this.inner = inner;
            this.setAnnotations(annotations);
        }

        public String getName() {
            return this.name;
        }

        @Override
        public Connection create(DataSource dataSource) throws ConnectionCreationException {
            return this.inner.create(dataSource);
        }
    }
}

