/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mule.module.db.integration.model.DerbyTestDatabase;
import org.mule.module.db.integration.model.MySqlTestDatabase;
import org.mule.module.db.integration.model.OracleTestDatabase;

public class TestDbConfig {
    private static boolean USE_DERBY = true;
    private static boolean USE_MYSQL = false;
    private static boolean USE_ORACLE = false;

    public static List<Object[]> getResources() {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        result.addAll(TestDbConfig.getDerbyResource());
        result.addAll(TestDbConfig.getMySqlResource());
        result.addAll(TestDbConfig.getOracleResource());
        return result;
    }

    public static List<Object[]> getDerbyResource() {
        if (USE_DERBY) {
            return Collections.singletonList(new Object[]{"integration/derby-datasource.xml", new DerbyTestDatabase()});
        }
        return Collections.emptyList();
    }

    public static List<Object[]> getMySqlResource() {
        if (USE_MYSQL) {
            return Collections.singletonList(new Object[]{"integration/config/mysql-db-config.xml", new MySqlTestDatabase()});
        }
        return Collections.emptyList();
    }

    public static List<Object[]> getOracleResource() {
        if (USE_ORACLE) {
            return Collections.singletonList(new Object[]{"integration/config/oracle-db-config.xml", new OracleTestDatabase()});
        }
        return Collections.emptyList();
    }
}

