/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration;

import java.sql.SQLException;
import java.sql.Struct;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.mule.api.MuleMessage;
import org.mule.module.db.integration.matcher.FieldMatcher;
import org.mule.module.db.integration.model.Alien;
import org.mule.module.db.integration.model.Field;
import org.mule.module.db.integration.model.Planet;
import org.mule.module.db.integration.model.Record;
import org.mule.module.db.integration.model.XmlField;

public class TestRecordUtil {
    public static Record[] getAllPlanetRecords() {
        return new Record[]{TestRecordUtil.getVenusRecord(), TestRecordUtil.getEarthRecord(), TestRecordUtil.getMarsRecord()};
    }

    public static Record[] getAllAlienRecords() {
        return new Record[]{TestRecordUtil.getMonguitoRecord(), TestRecordUtil.getEtRecord()};
    }

    public static void assertMessageContains(MuleMessage message, Record ... records) {
        TestRecordUtil.assertRecords(message.getPayload(), records);
    }

    public static void assertRecords(Object value, Record ... records) {
        Assert.assertTrue((String)("Expected a list but received: " + (value == null ? "null" : value.getClass().getName())), (boolean)(value instanceof List));
        List resultList = (List)value;
        Assert.assertThat((Object)resultList.size(), (Matcher)IsEqual.equalTo((Object)records.length));
        int recordsLength = records.length;
        for (int i = 0; i < recordsLength; ++i) {
            Record actualRecord = TestRecordUtil.createRecord((Map)resultList.get(i));
            TestRecordUtil.assertRecord(records[i], actualRecord);
        }
    }

    private static Record createRecord(Map<String, Object> fields) {
        HashMap<String, Object> recordFields = new HashMap<String, Object>();
        for (String fieldName : fields.keySet()) {
            Object[] fieldValue = fields.get(fieldName);
            if (fieldValue instanceof Object[] && ((Object[])fieldValue).length > 0) {
                Object[] arrayValue = fieldValue;
                if (arrayValue[0] instanceof Struct) {
                    fieldValue = TestRecordUtil.convertStructToObjectArray((Struct)arrayValue[0]);
                }
            } else if (fieldValue instanceof Struct) {
                fieldValue = TestRecordUtil.convertStructToObjectArray((Struct)fieldValue);
            }
            recordFields.put(fieldName, fieldValue);
        }
        return new Record(recordFields);
    }

    private static Object[] convertStructToObjectArray(Struct value) {
        try {
            Object[] attributes = value.getAttributes();
            Object[] arrayFieldValue = new Object[attributes.length];
            for (int i = 0; i < attributes.length; ++i) {
                arrayFieldValue[i] = attributes[i];
            }
            return arrayFieldValue;
        }
        catch (SQLException e) {
            throw new IllegalArgumentException("Cannot transform Struct to Object[]");
        }
    }

    public static void assertRecord(Record expected, Record actual) {
        Record expectedRecord = expected;
        for (Field field : expectedRecord.getFields()) {
            Assert.assertThat((Object)actual, FieldMatcher.containsField(field));
        }
    }

    public static Record getMarsRecord() {
        return new Record(new Field("NAME", Planet.MARS.getName()));
    }

    public static Record getVenusRecord() {
        return new Record(new Field("NAME", Planet.VENUS.getName()));
    }

    public static Record getEarthRecord() {
        return new Record(new Field("NAME", Planet.EARTH.getName()));
    }

    public static Record getMonguitoRecord() {
        return new Record(new Field("NAME", Alien.MONGUITO.getName()), new XmlField("DESCRIPTION", Alien.MONGUITO.getXml()));
    }

    public static Record getEtRecord() {
        return new Record(new Field("NAME", Alien.ET.getName()), new XmlField("DESCRIPTION", Alien.ET.getXml()));
    }
}

