/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.bulkexecute;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleEvent;
import org.mule.construct.Flow;
import org.mule.module.db.integration.AbstractDbIntegrationTestCase;
import org.mule.module.db.integration.TestDbConfig;
import org.mule.module.db.integration.model.AbstractTestDatabase;
import org.mule.module.db.internal.debug.DbDebugInfoTestUtils;
import org.mule.module.db.internal.domain.query.QueryTemplate;
import org.mule.module.db.internal.domain.query.QueryType;
import org.mule.module.db.internal.processor.AbstractDbMessageProcessor;
import org.mule.tck.junit4.matcher.ObjectDebugInfoMatcher;

public class BulkExecuteDebugInfoTestCase
extends AbstractDbIntegrationTestCase {
    public static final String QUERY1 = "Query1";
    public static final String QUERY2 = "Query2";
    public static final QueryTemplate QUERY_TEMPLATE1 = new QueryTemplate("update PLANET set NAME='Mercury' where POSITION=0", QueryType.UPDATE, Collections.emptyList());
    public static final QueryTemplate QUERY_TEMPLATE2 = new QueryTemplate("update PLANET set NAME='Mercury' where POSITION=4", QueryType.UPDATE, Collections.emptyList());

    public BulkExecuteDebugInfoTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        return TestDbConfig.getDerbyResource();
    }

    @Override
    protected String[] getFlowConfigurationResources() {
        return new String[]{"integration/bulkexecute/bulk-execute-default-config.xml"};
    }

    @Test
    public void returnsDebugInfo() throws Exception {
        Flow flowConstruct = (Flow)muleContext.getRegistry().lookupFlowConstruct("bulkUpdateRequestResponse");
        List messageProcessors = flowConstruct.getMessageProcessors();
        AbstractDbMessageProcessor queryMessageProcessor = (AbstractDbMessageProcessor)messageProcessors.get(0);
        MuleEvent muleEvent = BulkExecuteDebugInfoTestCase.getTestEvent((Object)"Test Message");
        List debugInfo = queryMessageProcessor.getDebugInfo(muleEvent);
        MatcherAssert.assertThat((Object)debugInfo, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)debugInfo.size(), (Matcher)Matchers.equalTo((Object)1));
        ArrayList queryMatchers = new ArrayList();
        queryMatchers.add(DbDebugInfoTestUtils.createQueryFieldDebugInfoMatcher(QUERY1, QUERY_TEMPLATE1));
        queryMatchers.add(DbDebugInfoTestUtils.createQueryFieldDebugInfoMatcher(QUERY2, QUERY_TEMPLATE2));
        MatcherAssert.assertThat((Object)debugInfo, (Matcher)Matchers.hasItem((Matcher)ObjectDebugInfoMatcher.objectLike((String)"Queries", List.class, queryMatchers)));
    }
}

