/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.delete;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.module.db.integration.AbstractDbIntegrationTestCase;
import org.mule.module.db.integration.DbTestUtil;
import org.mule.module.db.integration.TestDbConfig;
import org.mule.module.db.integration.model.AbstractTestDatabase;
import org.mule.module.db.integration.model.Planet;
import org.mule.transport.NullPayload;

public class DeleteBulkTestCase
extends AbstractDbIntegrationTestCase {
    public DeleteBulkTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        return TestDbConfig.getResources();
    }

    @Override
    protected String[] getFlowConfigurationResources() {
        return new String[]{"integration/delete/delete-bulk-config.xml"};
    }

    @Test
    public void deletesInBulkMode() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        ArrayList<String> planetNames = new ArrayList<String>();
        planetNames.add(Planet.VENUS.getName());
        planetNames.add(Planet.MARS.getName());
        MuleMessage response = client.send("vm://deleteBulk", planetNames, null);
        this.assertBulkDelete(response);
    }

    @Test
    public void requiresCollectionPayload() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://deleteBulk", (Object)"Test Message", null);
        Assert.assertTrue((boolean)(response.getPayload() instanceof NullPayload));
        Assert.assertNotNull((Object)response.getExceptionPayload());
    }

    private void assertBulkDelete(MuleMessage response) throws SQLException {
        Assert.assertTrue((boolean)(response.getPayload() instanceof int[]));
        int[] counters = (int[])response.getPayload();
        Assert.assertEquals((long)2L, (long)counters.length);
        DbTestUtil.assertExpectedUpdateCount(1, counters[0]);
        DbTestUtil.assertExpectedUpdateCount(1, counters[1]);
        this.assertDeletedPlanetRecords(Planet.VENUS.getName());
    }
}

