/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.matcher;

import java.util.List;
import java.util.Map;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.junit.internal.matchers.TypeSafeMatcher;
import org.mule.api.MuleMessage;

public class ContainsMessage
extends TypeSafeMatcher<List<MuleMessage>> {
    private final String key;
    private final Object value;

    public ContainsMessage(String key, Object value) {
        this.key = key;
        this.value = value;
    }

    public boolean matchesSafely(List<MuleMessage> messages) {
        for (MuleMessage message : messages) {
            if (!(message.getPayload() instanceof Map) || !((Map)message.getPayload()).get(this.key).equals(this.value)) continue;
            return true;
        }
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("Does not contains a map payload with key = " + this.key + " and value = " + this.value);
    }

    @Factory
    public static Matcher<List<MuleMessage>> mapPayloadWith(String key, Object value) {
        return new ContainsMessage(key, value);
    }
}

