/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.matcher;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.hamcrest.Description;
import org.mule.module.db.integration.matcher.AbstractDataSourceFeatureMatcher;

public class SupportsReturningStoredProcedureResultsWithoutParameters
extends AbstractDataSourceFeatureMatcher {
    private static final Set<String> supportedProducts = new HashSet<String>();

    @Override
    protected boolean supportsFeature(DatabaseMetaData metaData) throws SQLException {
        String productName = metaData.getDatabaseProductName().toUpperCase();
        return supportedProducts.contains(productName);
    }

    public void describeTo(Description description) {
        description.appendText("Database only returns stored procedure results with output parameters");
    }

    static {
        supportedProducts.add("MYSQL");
        supportedProducts.add("APACHE DERBY");
    }
}

