/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.model;

import org.mule.module.db.integration.model.FieldUtils;

public class Field {
    private final String name;
    private final Object value;

    public Field(String name, Object value) {
        this.name = name.toUpperCase();
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Field field = (Field)o;
        return this.name.equals(field.name) && !(this.value == null ? field.value != null : !this.checkEqualValues(field));
    }

    protected boolean checkEqualValues(Field field) {
        if (this.value instanceof Object[] && field.value instanceof Object[]) {
            Object[] arrayValue = (Object[])this.value;
            Object[] arrayFieldValue = (Object[])field.value;
            if (arrayValue.length == arrayFieldValue.length) {
                String s1 = FieldUtils.getValueAsString(arrayValue);
                String s2 = FieldUtils.getValueAsString(arrayFieldValue);
                return s1.equals(s2);
            }
            return false;
        }
        return this.value.toString().equals(field.value.toString());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "{" + this.name + ", " + FieldUtils.getValueAsString(this.value) + "}";
    }
}

