/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.model;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.mule.common.metadata.datatype.DataType;
import org.mule.module.db.integration.model.AbstractTestDatabase;
import org.mule.module.db.integration.model.Alien;
import org.mule.module.db.integration.model.Contact;
import org.mule.module.db.integration.model.ContactDetails;
import org.mule.module.db.integration.model.Region;
import org.mule.module.db.integration.model.RegionManager;

public class OracleTestDatabase
extends AbstractTestDatabase {
    @Override
    public void createPlanetTable(Connection connection) throws SQLException {
        OracleTestDatabase.executeDdl(connection, "CREATE TABLE PLANET(ID INTEGER NOT NULL PRIMARY KEY,POSITION SMALLINT, NAME VARCHAR(255), DESCRIPTION CLOB)");
        OracleTestDatabase.executeDdl(connection, "CREATE SEQUENCE PLANET_SEQ INCREMENT BY 1 START WITH 1");
        OracleTestDatabase.executeDdl(connection, "CREATE TRIGGER PLANET_TRIGGER\nBEFORE INSERT ON PLANET\nFOR EACH ROW WHEN (new.ID is null)\nbegin\n    select PLANET_SEQ.nextval into :new.ID from dual;\nend;");
    }

    @Override
    protected String getInsertPlanetSql(String name, int position) {
        return "INSERT INTO PLANET(ID, POSITION, NAME) VALUES (PLANET_SEQ.NEXTVAL, " + position + ", '" + name + "')";
    }

    @Override
    public void createStoredProcedureGetRecords(DataSource dataSource) throws SQLException {
        String sql = "CREATE OR REPLACE PROCEDURE getTestRecords ( st_cursor OUT SYS_REFCURSOR  )\n     is\n BEGIN\n  OPEN st_cursor FOR\n  SELECT * FROM PLANET;\n end;\n";
        this.createStoredProcedure(dataSource, "CREATE OR REPLACE PROCEDURE getTestRecords ( st_cursor OUT SYS_REFCURSOR  )\n     is\n BEGIN\n  OPEN st_cursor FOR\n  SELECT * FROM PLANET;\n end;\n");
    }

    @Override
    public void createFunctionGetRecords(DataSource dataSource) throws SQLException {
        String query = "CREATE OR REPLACE FUNCTION getTestRecordsFunction\nRETURN SYS_REFCURSOR\nIS planet_cursor SYS_REFCURSOR;\nBEGIN\n  OPEN planet_cursor FOR\n  SELECT * FROM planet;\n  RETURN planet_cursor;\nEND;";
        OracleTestDatabase.executeDdl(dataSource, query);
    }

    @Override
    public void createStoredProcedureUpdateTestType1(DataSource dataSource) throws SQLException {
        String sql = "CREATE OR REPLACE PROCEDURE updateTestType1 (p_retVal OUT INTEGER)\nAS\nBEGIN\n  UPDATE PLANET SET NAME='Mercury' WHERE POSITION=4;\n   p_retVal := SQL%ROWCOUNT;\nEND;";
        this.createStoredProcedure(dataSource, "CREATE OR REPLACE PROCEDURE updateTestType1 (p_retVal OUT INTEGER)\nAS\nBEGIN\n  UPDATE PLANET SET NAME='Mercury' WHERE POSITION=4;\n   p_retVal := SQL%ROWCOUNT;\nEND;");
    }

    @Override
    public void createStoredProcedureParameterizedUpdateTestType1(DataSource dataSource) throws SQLException {
        String sql = "CREATE OR REPLACE PROCEDURE updateParamTestType1 (p_name IN VARCHAR2, p_retVal OUT INTEGER)\nAS\nBEGIN\n  UPDATE PLANET SET NAME=p_Name WHERE POSITION=4;\n\n   p_retVal := SQL%ROWCOUNT;\nEND;";
        this.createStoredProcedure(dataSource, "CREATE OR REPLACE PROCEDURE updateParamTestType1 (p_name IN VARCHAR2, p_retVal OUT INTEGER)\nAS\nBEGIN\n  UPDATE PLANET SET NAME=p_Name WHERE POSITION=4;\n\n   p_retVal := SQL%ROWCOUNT;\nEND;");
    }

    @Override
    public void createStoredProcedureParameterizedUpdatePlanetDescription(DataSource dataSource) throws SQLException {
        String sql = "CREATE OR REPLACE PROCEDURE updatePlanetDescription (p_name IN VARCHAR2, p_description CLOB)\nAS\nBEGIN\n  UPDATE PLANET SET DESCRIPTION=p_description WHERE name=p_name;\nEND;";
        this.createStoredProcedure(dataSource, "CREATE OR REPLACE PROCEDURE updatePlanetDescription (p_name IN VARCHAR2, p_description CLOB)\nAS\nBEGIN\n  UPDATE PLANET SET DESCRIPTION=p_description WHERE name=p_name;\nEND;");
    }

    @Override
    public void createStoredProcedureCountRecords(DataSource dataSource) throws SQLException {
        String sql = "CREATE OR REPLACE PROCEDURE countTestRecords(count OUT NUMBER) IS\nBEGIN\n   SELECT COUNT(*)\n   INTO   count\n   FROM   PLANET;\nEND countTestRecords;";
        this.createStoredProcedure(dataSource, "CREATE OR REPLACE PROCEDURE countTestRecords(count OUT NUMBER) IS\nBEGIN\n   SELECT COUNT(*)\n   INTO   count\n   FROM   PLANET;\nEND countTestRecords;");
    }

    @Override
    public void createStoredProcedureGetSplitRecords(DataSource dataSource) throws SQLException {
        String sql = "CREATE OR REPLACE PROCEDURE getSplitTestRecords ( st_cursor1 OUT SYS_REFCURSOR, st_cursor2 OUT SYS_REFCURSOR  )\nis\nBEGIN\n   OPEN st_cursor1 FOR SELECT * FROM PLANET WHERE POSITION <= 2;\n   OPEN st_cursor2 FOR SELECT * FROM PLANET WHERE POSITION > 2;\nEND;";
        this.createStoredProcedure(dataSource, "CREATE OR REPLACE PROCEDURE getSplitTestRecords ( st_cursor1 OUT SYS_REFCURSOR, st_cursor2 OUT SYS_REFCURSOR  )\nis\nBEGIN\n   OPEN st_cursor1 FOR SELECT * FROM PLANET WHERE POSITION <= 2;\n   OPEN st_cursor2 FOR SELECT * FROM PLANET WHERE POSITION > 2;\nEND;");
    }

    @Override
    public void createStoredProcedureDoubleMyInt(DataSource dataSource) throws SQLException {
        String sql = "CREATE OR REPLACE PROCEDURE doubleMyInt(MYINT IN OUT NUMBER) IS\nBEGIN\n    SELECT MYINT * 2 \n    INTO   MYINT\n    FROM   DUAL;\nEND doubleMyInt;";
        this.createStoredProcedure(dataSource, "CREATE OR REPLACE PROCEDURE doubleMyInt(MYINT IN OUT NUMBER) IS\nBEGIN\n    SELECT MYINT * 2 \n    INTO   MYINT\n    FROM   DUAL;\nEND doubleMyInt;");
    }

    @Override
    public void createStoredProcedureMultiplyInts(DataSource dataSource) throws SQLException {
        String sql = "CREATE OR REPLACE PROCEDURE multiplyInts(INT1 IN NUMBER, INT2 IN NUMBER, RESULT1 OUT NUMBER, INT3 IN NUMBER, RESULT2 OUT NUMBER) IS\nBEGIN\n    SELECT INT1 * INT2 \n    INTO   RESULT1\n    FROM   DUAL;\n    SELECT INT1 * INT2 * INT3 \n    INTO   RESULT2\n    FROM   DUAL;\nEND multiplyInts;";
        this.createStoredProcedure(dataSource, "CREATE OR REPLACE PROCEDURE multiplyInts(INT1 IN NUMBER, INT2 IN NUMBER, RESULT1 OUT NUMBER, INT3 IN NUMBER, RESULT2 OUT NUMBER) IS\nBEGIN\n    SELECT INT1 * INT2 \n    INTO   RESULT1\n    FROM   DUAL;\n    SELECT INT1 * INT2 * INT3 \n    INTO   RESULT2\n    FROM   DUAL;\nEND multiplyInts;");
    }

    @Override
    public void createStoredProcedureConcatenateStrings(DataSource dataSource) throws SQLException {
        String sql = "CREATE OR REPLACE PROCEDURE concatenateStrings(STRING1 IN VARCHAR2, STRING2 IN VARCHAR2, RESULT OUT VARCHAR2) IS\nBEGIN\n    SELECT STRING1 || STRING2\n    INTO   RESULT\n    FROM   DUAL;\nEND concatenateStrings;";
        this.createStoredProcedure(dataSource, "CREATE OR REPLACE PROCEDURE concatenateStrings(STRING1 IN VARCHAR2, STRING2 IN VARCHAR2, RESULT OUT VARCHAR2) IS\nBEGIN\n    SELECT STRING1 || STRING2\n    INTO   RESULT\n    FROM   DUAL;\nEND concatenateStrings;");
    }

    @Override
    public void createDelayFunction(DataSource dataSource) throws SQLException {
        String sql = "CREATE OR REPLACE FUNCTION DELAY(seconds number) RETURN number IS targetDate DATE; BEGIN SELECT sysdate + seconds * 10/864 INTO targetDate FROM DUAL; LOOP EXIT WHEN SYSDATE >= targetDate; END LOOP; RETURN 1; END;";
        this.createStoredProcedure(dataSource, "CREATE OR REPLACE FUNCTION DELAY(seconds number) RETURN number IS targetDate DATE; BEGIN SELECT sysdate + seconds * 10/864 INTO targetDate FROM DUAL; LOOP EXIT WHEN SYSDATE >= targetDate; END LOOP; RETURN 1; END;");
    }

    @Override
    public Class getIdFieldJavaClass() {
        return BigDecimal.class;
    }

    @Override
    public Class getDefaultAutoGeneratedKeyClass() {
        try {
            return Class.forName("oracle.sql.ROWID");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to load ROWDID class");
        }
    }

    @Override
    public DataType getIdFieldInputMetaDataType() {
        return DataType.DECIMAL;
    }

    @Override
    public DataType getIdFieldOutputMetaDataType() {
        return DataType.DECIMAL;
    }

    @Override
    public DataType getPositionFieldOutputMetaDataType() {
        return DataType.DECIMAL;
    }

    @Override
    protected void createAlienTable(Connection connection) throws SQLException {
        String ddl = "CREATE TABLE ALIEN(\n  NAME varchar2(255),\n  DESCRIPTION XMLTYPE)";
        OracleTestDatabase.executeDdl(connection, ddl);
    }

    @Override
    protected String getInsertAlienSql(Alien alien) {
        String sql = "INSERT INTO Alien VALUES ('" + alien.getName() + "' , XMLType('" + alien.getXml() + "'))";
        return sql;
    }

    @Override
    public void createStoredProcedureGetAlienDescription(DataSource dataSource) throws SQLException {
        String sql = "CREATE OR REPLACE PROCEDURE getAlienDescription(pName IN VARCHAR2, pDescription OUT XMLType)\nIS\nBEGIN\n    select description into pDescription from Alien where name= pName; \nEND;\n";
        OracleTestDatabase.executeDdl(dataSource, "CREATE OR REPLACE PROCEDURE getAlienDescription(pName IN VARCHAR2, pDescription OUT XMLType)\nIS\nBEGIN\n    select description into pDescription from Alien where name= pName; \nEND;\n");
    }

    @Override
    protected boolean supportsXmlType() {
        return true;
    }

    @Override
    public void createStoredProcedureUpdateAlienDescription(DataSource dataSource) throws SQLException {
        String sql = "CREATE OR REPLACE PROCEDURE updateAlienDescription(pName IN VARCHAR2, pDescription in XMLType)\nIS\nBEGIN\n    update Alien set description = pDescription where name= pName; \nEND;\n";
        OracleTestDatabase.executeDdl(dataSource, "CREATE OR REPLACE PROCEDURE updateAlienDescription(pName IN VARCHAR2, pDescription in XMLType)\nIS\nBEGIN\n    update Alien set description = pDescription where name= pName; \nEND;\n");
    }

    @Override
    protected boolean supportsSimpleUdt() {
        return true;
    }

    @Override
    protected boolean supportsArraysUdt() {
        return true;
    }

    @Override
    protected void createZipArrayType(Connection connection) throws SQLException {
        String ddl = "CREATE OR REPLACE TYPE ZIPARRAY AS VARRAY(10) OF VARCHAR2(12)";
        OracleTestDatabase.executeDdl(connection, "CREATE OR REPLACE TYPE ZIPARRAY AS VARRAY(10) OF VARCHAR2(12)");
    }

    @Override
    protected void createContactDetailsType(Connection connection) throws SQLException {
        block2: {
            String ddl = "CREATE OR REPLACE TYPE CONTACT_DETAILS AS object(DESCRIPTION VARCHAR2(12),PHONE_NUMBER VARCHAR2(12),EMAIL_ADDRESS VARCHAR2(100))";
            try {
                OracleTestDatabase.executeDdl(connection, "CREATE OR REPLACE TYPE CONTACT_DETAILS AS object(DESCRIPTION VARCHAR2(12),PHONE_NUMBER VARCHAR2(12),EMAIL_ADDRESS VARCHAR2(100))");
            }
            catch (SQLException e) {
                if (e.getMessage().contains("ORA-02303")) break block2;
                throw e;
            }
        }
    }

    @Override
    protected void createContactDetailsArrayType(Connection connection) throws SQLException {
        String ddl = "CREATE OR REPLACE TYPE CONTACT_DETAILS_ARRAY AS VARRAY(100) OF CONTACT_DETAILS";
        OracleTestDatabase.executeDdl(connection, "CREATE OR REPLACE TYPE CONTACT_DETAILS_ARRAY AS VARRAY(100) OF CONTACT_DETAILS");
    }

    @Override
    public void createStoredProcedureGetZipCodes(DataSource dataSource) throws SQLException {
        String sql = "CREATE OR REPLACE PROCEDURE getZipCodes(pName IN VARCHAR2, pZipCodes OUT ZIPARRAY) IS BEGIN select ZIPS into pZipCodes from REGIONS where REGION_NAME = pName; END;";
        OracleTestDatabase.executeDdl(dataSource, "CREATE OR REPLACE PROCEDURE getZipCodes(pName IN VARCHAR2, pZipCodes OUT ZIPARRAY) IS BEGIN select ZIPS into pZipCodes from REGIONS where REGION_NAME = pName; END;");
    }

    @Override
    public void createStoredProcedureUpdateZipCodes(DataSource dataSource) throws SQLException {
        String sql = "CREATE OR REPLACE PROCEDURE updateZipCodes(pName IN VARCHAR2, pZipCodes IN ZIPARRAY) IS BEGIN UPDATE REGIONS SET ZIPS = pZipCodes where REGION_NAME = pName; END;";
        OracleTestDatabase.executeDdl(dataSource, "CREATE OR REPLACE PROCEDURE updateZipCodes(pName IN VARCHAR2, pZipCodes IN ZIPARRAY) IS BEGIN UPDATE REGIONS SET ZIPS = pZipCodes where REGION_NAME = pName; END;");
    }

    @Override
    public void createStoredProcedureUpdateContactDetails(DataSource dataSource) throws SQLException {
        String sql = "CREATE OR REPLACE PROCEDURE updateContactDetails(pName IN VARCHAR2, pDetails IN CONTACT_DETAILS_ARRAY) IS BEGIN UPDATE CONTACTS SET DETAILS = pDetails where CONTACT_NAME= pName;END;";
        OracleTestDatabase.executeDdl(dataSource, "CREATE OR REPLACE PROCEDURE updateContactDetails(pName IN VARCHAR2, pDetails IN CONTACT_DETAILS_ARRAY) IS BEGIN UPDATE CONTACTS SET DETAILS = pDetails where CONTACT_NAME= pName;END;");
    }

    @Override
    public void createStoredProcedureGetContactDetails(DataSource dataSource) throws SQLException {
        String sql = "CREATE OR REPLACE PROCEDURE getContactDetails(pName IN VARCHAR2, pContactDetails OUT CONTACT_DETAILS_ARRAY) IS BEGIN select DETAILS into pContactDetails from CONTACTS where CONTACT_NAME= pName; END;";
        OracleTestDatabase.executeDdl(dataSource, "CREATE OR REPLACE PROCEDURE getContactDetails(pName IN VARCHAR2, pContactDetails OUT CONTACT_DETAILS_ARRAY) IS BEGIN select DETAILS into pContactDetails from CONTACTS where CONTACT_NAME= pName; END;");
    }

    @Override
    public void createStoredProcedureGetManagerDetails(DataSource dataSource) throws SQLException {
        String sql = "CREATE OR REPLACE PROCEDURE getManagerDetails(pName IN VARCHAR2, pDetails OUT CONTACT_DETAILS) IS BEGIN select DETAILS into pDetails from REGION_MANAGERS where REGION_NAME= pName; END;";
        OracleTestDatabase.executeDdl(dataSource, "CREATE OR REPLACE PROCEDURE getManagerDetails(pName IN VARCHAR2, pDetails OUT CONTACT_DETAILS) IS BEGIN select DETAILS into pDetails from REGION_MANAGERS where REGION_NAME= pName; END;");
    }

    @Override
    protected String getInsertContactSql(Contact contact) {
        StringBuilder builder = new StringBuilder("INSERT INTO CONTACTS VALUES ('").append(contact.getName()).append("', CONTACT_DETAILS_ARRAY(");
        boolean first = true;
        for (ContactDetails contactDetails : contact.getDetails()) {
            if (first) {
                first = false;
            } else {
                builder.append(",");
            }
            builder.append("CONTACT_DETAILS('").append(contactDetails.getDescription()).append("', '").append(contactDetails.getPhoneNumber()).append("', '").append(contactDetails.getEmail()).append("')");
        }
        builder.append("))");
        return builder.toString();
    }

    @Override
    protected void createContactsTable(Connection connection) throws SQLException {
        String ddl = "create table CONTACTS (CONTACT_NAME varchar(32) NOT NULL,DETAILS CONTACT_DETAILS_ARRAY NOT NULL,PRIMARY KEY (CONTACT_NAME))";
        OracleTestDatabase.executeDdl(connection, ddl);
    }

    @Override
    protected void deleteContactsTable(Connection connection) throws SQLException {
        this.executeUpdate(connection, "DELETE FROM CONTACTS");
    }

    @Override
    protected String getInsertRegionSql(Region region) {
        StringBuilder builder = new StringBuilder("INSERT INTO REGIONS VALUES ('").append(region.getName()).append("', ").append(" ZIPARRAY(");
        boolean first = true;
        for (String zipCode : region.getZips()) {
            if (first) {
                first = false;
            } else {
                builder.append(",");
            }
            builder.append(zipCode);
        }
        builder.append("))");
        return builder.toString();
    }

    @Override
    protected void createRegionsTable(Connection connection) throws SQLException {
        String ddl = "create table REGIONS (REGION_NAME varchar(32) NOT NULL,ZIPS ZIPARRAY NOT NULL,PRIMARY KEY (REGION_NAME))";
        OracleTestDatabase.executeDdl(connection, ddl);
    }

    @Override
    protected void deleteRegionsTable(Connection connection) throws SQLException {
        this.executeUpdate(connection, "DELETE FROM REGIONS");
    }

    @Override
    protected void createRegionManagersTable(Connection connection) throws SQLException {
        String ddl = "create table REGION_MANAGERS(REGION_NAME varchar(32) NOT NULL,MANAGER_NAME varchar(32) NOT NULL,DETAILS CONTACT_DETAILS NOT NULL,PRIMARY KEY (REGION_NAME));";
        OracleTestDatabase.executeDdl(connection, ddl);
    }

    @Override
    protected void deleteRegionManagersTable(Connection connection) throws SQLException {
        this.executeUpdate(connection, "DELETE FROM REGION_MANAGERS");
    }

    @Override
    protected String getInsertRegionManagerSql(RegionManager regionManager) {
        StringBuilder builder = new StringBuilder("INSERT INTO REGION_MANAGERS VALUES ('").append(regionManager.getRegionName()).append("', '").append(regionManager.getName()).append("', CONTACT_DETAILS('").append(regionManager.getContactDetails().getDescription()).append("', '").append(regionManager.getContactDetails().getPhoneNumber()).append("', '").append(regionManager.getContactDetails().getEmail()).append("'))");
        return builder.toString();
    }
}

