/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.select;

import java.util.ArrayList;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mockito.Matchers;
import org.mule.common.Result;
import org.mule.common.metadata.DefaultListMetaDataModel;
import org.mule.common.metadata.DefinedMapMetaDataModel;
import org.mule.common.metadata.MetaData;
import org.mule.construct.Flow;
import org.mule.module.db.integration.AbstractDbIntegrationTestCase;
import org.mule.module.db.integration.TestDbConfig;
import org.mule.module.db.integration.model.AbstractTestDatabase;
import org.mule.module.db.internal.processor.AbstractSingleQueryDbMessageProcessor;

public class SelectJoinOutputMetadataTestCase
extends AbstractDbIntegrationTestCase {
    public SelectJoinOutputMetadataTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        return TestDbConfig.getResources();
    }

    @Override
    protected String[] getFlowConfigurationResources() {
        return new String[]{"integration/select/select-join-output-metadata-config.xml"};
    }

    @Test
    public void returnsSelectOutputMetadata() throws Exception {
        Flow flowConstruct = (Flow)muleContext.getRegistry().lookupFlowConstruct("joinMetadata");
        List messageProcessors = flowConstruct.getMessageProcessors();
        AbstractSingleQueryDbMessageProcessor queryMessageProcessor = (AbstractSingleQueryDbMessageProcessor)messageProcessors.get(0);
        Result outputMetaData = queryMessageProcessor.getOutputMetaData(null);
        DefaultListMetaDataModel listMetaDataModel = (DefaultListMetaDataModel)((MetaData)outputMetaData.get()).getPayload();
        Assert.assertThat((Object)ArrayList.class.getName(), (Matcher)CoreMatchers.equalTo((Object)listMetaDataModel.getImplementationClass()));
        DefinedMapMetaDataModel mapDataModel = (DefinedMapMetaDataModel)listMetaDataModel.getElementModel();
        Assert.assertThat((Object)mapDataModel.getKeys().size(), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((Object)mapDataModel.getValueMetaDataModel("NAME"), (Matcher)CoreMatchers.not((Object)Matchers.isNull()));
        Assert.assertThat((Object)mapDataModel.getValueMetaDataModel("NAME2"), (Matcher)CoreMatchers.not((Object)Matchers.isNull()));
    }

    @Test
    public void detectsInvalidSelectOutputMetadata() throws Exception {
        Flow flowConstruct = (Flow)muleContext.getRegistry().lookupFlowConstruct("joinInvalidMetadata");
        List messageProcessors = flowConstruct.getMessageProcessors();
        AbstractSingleQueryDbMessageProcessor queryMessageProcessor = (AbstractSingleQueryDbMessageProcessor)messageProcessors.get(0);
        Result outputMetaData = queryMessageProcessor.getOutputMetaData(null);
        Assert.assertThat((Object)outputMetaData.getStatus(), (Matcher)CoreMatchers.equalTo((Object)Result.Status.FAILURE));
        Assert.assertThat((Object)outputMetaData.get(), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)outputMetaData.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"Query metadata contains multiple columns with the same label. Define column aliases to resolve this problem"));
    }
}

