/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.select;

import java.util.List;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.module.db.integration.AbstractDbIntegrationTestCase;
import org.mule.module.db.integration.TestDbConfig;
import org.mule.module.db.integration.TestRecordUtil;
import org.mule.module.db.integration.model.AbstractTestDatabase;
import org.mule.tck.junit4.rule.SystemProperty;

public class SelectWithPlaceHolderTestCase
extends AbstractDbIntegrationTestCase {
    @Rule
    public SystemProperty query = new SystemProperty("query", "select * from PLANET order by ID");
    @Rule
    public SystemProperty param = new SystemProperty("param", "2");

    public SelectWithPlaceHolderTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        return TestDbConfig.getResources();
    }

    @Override
    protected String[] getFlowConfigurationResources() {
        return new String[]{"integration/select/select-placeholder-config.xml"};
    }

    @Test
    public void replacesPlaceholderInParameterizedQuery() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://placeholderParameterizedQuery", (Object)"Test Message", null);
        TestRecordUtil.assertMessageContains(response, TestRecordUtil.getAllPlanetRecords());
    }

    @Test
    public void replacesPlaceholderInDynamicQuery() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://placeholderDynamicQuery", (Object)"Test Message", null);
        TestRecordUtil.assertMessageContains(response, TestRecordUtil.getAllPlanetRecords());
    }

    @Test
    public void replacesPlaceholderInParameterizedQueryParam() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://placeholderParameterizedQueryParam", (Object)"Test Message", null);
        TestRecordUtil.assertMessageContains(response, TestRecordUtil.getVenusRecord());
    }
}

