/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.storedprocedure;

import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.module.db.integration.AbstractDbIntegrationTestCase;
import org.mule.module.db.integration.TestDbConfig;
import org.mule.module.db.integration.TestRecordUtil;
import org.mule.module.db.integration.matcher.SupportsStoredFunctionsUsingCallSyntax;
import org.mule.module.db.integration.model.AbstractTestDatabase;
import org.mule.module.db.integration.model.MySqlTestDatabase;

@Ignore(value="DB vendors/drivers do not use maxRows as described in Statement's javadoc")
public class StoreProcedureMaxRowsTestCase
extends AbstractDbIntegrationTestCase {
    public StoreProcedureMaxRowsTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        return TestDbConfig.getResources();
    }

    @Override
    protected String[] getFlowConfigurationResources() {
        return new String[]{"integration/storedprocedure/stored-procedure-max-rows-config.xml"};
    }

    @Test
    public void testRequestResponse() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://testRequestResponse", (Object)"Test Message", null);
        Map payload = (Map)response.getPayload();
        if (this.testDatabase instanceof MySqlTestDatabase) {
            Assert.assertThat((Object)payload.size(), (Matcher)IsEqual.equalTo((Object)2));
            Assert.assertThat((Object)((Integer)payload.get("updateCount1")), (Matcher)IsEqual.equalTo((Object)0));
        } else {
            Assert.assertThat((Object)payload.size(), (Matcher)IsEqual.equalTo((Object)1));
        }
        TestRecordUtil.assertRecords(payload.get("resultSet1"), TestRecordUtil.getVenusRecord());
    }

    @Before
    public void setupStoredProcedure() throws Exception {
        Assume.assumeThat((Object)this.getDefaultDataSource(), (Matcher)new SupportsStoredFunctionsUsingCallSyntax());
        this.testDatabase.createStoredProcedureGetRecords(this.getDefaultDataSource());
    }
}

