/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.update;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.client.MuleClient;
import org.mule.module.db.integration.AbstractDbIntegrationTestCase;
import org.mule.module.db.integration.DbTestUtil;
import org.mule.module.db.integration.TestDbConfig;
import org.mule.module.db.integration.TestRecordUtil;
import org.mule.module.db.integration.model.AbstractTestDatabase;
import org.mule.module.db.integration.model.Field;
import org.mule.module.db.integration.model.Planet;
import org.mule.module.db.integration.model.Record;
import org.mule.transport.NullPayload;

public class UpdateBulkTestCase
extends AbstractDbIntegrationTestCase {
    private MuleClient client;

    public UpdateBulkTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        return TestDbConfig.getResources();
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.client = muleContext.getClient();
    }

    @Override
    protected String[] getFlowConfigurationResources() {
        return new String[]{"integration/update/update-bulk-config.xml"};
    }

    @Test
    public void updatesInBulkModeWithCollection() throws Exception {
        MuleMessage response = this.client.send("vm://updateBulk", this.getPlanetNames(), null);
        this.assertBulkModeResult(response);
    }

    @Test
    public void updatesInBulkModeWithIterator() throws Exception {
        MuleMessage response = this.client.send("vm://updateBulk", this.getPlanetNames().iterator(), null);
        this.assertBulkModeResult(response);
    }

    @Test
    public void updatesInBulkModeWithIterable() throws Exception {
        final List<String> planetNames = this.getPlanetNames();
        Iterable<String> iterable = new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return planetNames.iterator();
            }
        };
        MuleMessage response = this.client.send("vm://updateBulk", (Object)iterable, null);
        this.assertBulkModeResult(response);
    }

    @Test
    public void requiresSplittableType() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://updateBulk", (Object)"Test Message", null);
        Assert.assertTrue((boolean)(response.getPayload() instanceof NullPayload));
        Assert.assertNotNull((Object)response.getExceptionPayload());
    }

    private void assertBulkModeResult(MuleMessage response) throws SQLException {
        Assert.assertTrue((boolean)(response.getPayload() instanceof int[]));
        int[] counters = (int[])response.getPayload();
        Assert.assertThat((Object)counters[0], (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.equalTo((Object)1), (Matcher)CoreMatchers.equalTo((Object)-2)));
        Assert.assertThat((Object)counters[1], (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.equalTo((Object)1), (Matcher)CoreMatchers.equalTo((Object)-2)));
        Assert.assertThat((Object)counters[2], (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.equalTo((Object)1), (Matcher)CoreMatchers.equalTo((Object)-2)));
        List result = DbTestUtil.selectData("select * from PLANET order by ID", this.getDefaultDataSource());
        TestRecordUtil.assertRecords(result, new Record(new Field("NAME", "Mercury"), new Field("POSITION", 2)), new Record(new Field("NAME", "Mercury"), new Field("POSITION", 3)), new Record(new Field("NAME", "Mercury"), new Field("POSITION", 4)));
    }

    private List<String> getPlanetNames() {
        ArrayList<String> planetNames = new ArrayList<String>();
        planetNames.add(Planet.VENUS.getName());
        planetNames.add(Planet.MARS.getName());
        planetNames.add(Planet.EARTH.getName());
        return planetNames;
    }
}

