/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.update;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.api.debug.FieldDebugInfo;
import org.mule.construct.Flow;
import org.mule.module.db.integration.model.AbstractTestDatabase;
import org.mule.module.db.integration.update.UpdateBulkTestCase;
import org.mule.module.db.internal.debug.DbDebugInfoTestUtils;
import org.mule.module.db.internal.domain.query.QueryTemplate;
import org.mule.module.db.internal.domain.query.QueryType;
import org.mule.module.db.internal.processor.AbstractDbMessageProcessor;
import org.mule.tck.junit4.matcher.ObjectDebugInfoMatcher;

public class UpdateDynamicBulkDebugInfoTestCase
extends UpdateBulkTestCase {
    public static final String QUERY1 = "Query1";
    public static final String QUERY2 = "Query2";

    public UpdateDynamicBulkDebugInfoTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Override
    protected String[] getFlowConfigurationResources() {
        return new String[]{"integration/update/update-dynamic-bulk-config.xml"};
    }

    @Test
    public void providesDebugInfo() throws Exception {
        Flow flowConstruct = (Flow)muleContext.getRegistry().lookupFlowConstruct("updateBulk");
        List messageProcessors = flowConstruct.getMessageProcessors();
        AbstractDbMessageProcessor queryMessageProcessor = (AbstractDbMessageProcessor)messageProcessors.get(0);
        ArrayList<String> planetNames = new ArrayList<String>();
        planetNames.add("EARTH");
        planetNames.add("MARS");
        MuleEvent muleEvent = UpdateDynamicBulkDebugInfoTestCase.getTestEvent(planetNames);
        List debugInfo = queryMessageProcessor.getDebugInfo(muleEvent);
        MatcherAssert.assertThat((Object)debugInfo, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)debugInfo.size(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)debugInfo, (Matcher)Matchers.hasItem((Matcher)ObjectDebugInfoMatcher.objectLike((String)"Queries", List.class, this.createExpectedQueryMatchers())));
    }

    private List<Matcher<FieldDebugInfo<?>>> createExpectedQueryMatchers() {
        ArrayList queriesDebugInfo = new ArrayList();
        queriesDebugInfo.add(DbDebugInfoTestUtils.createQueryFieldDebugInfoMatcher(QUERY1, new QueryTemplate("update PLANET set NAME='Mercury' where NAME='EARTH'", QueryType.UPDATE, Collections.emptyList())));
        queriesDebugInfo.add(DbDebugInfoTestUtils.createQueryFieldDebugInfoMatcher(QUERY2, new QueryTemplate("update PLANET set NAME='Mercury' where NAME='MARS'", QueryType.UPDATE, Collections.emptyList())));
        return queriesDebugInfo;
    }
}

