/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.config.domain.query;

import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsEqual;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.module.db.internal.config.domain.query.ParameterizedQueryTemplateFactoryBean;
import org.mule.module.db.internal.domain.param.DefaultInOutQueryParam;
import org.mule.module.db.internal.domain.param.DefaultInputQueryParam;
import org.mule.module.db.internal.domain.param.DefaultOutputQueryParam;
import org.mule.module.db.internal.domain.param.InOutQueryParam;
import org.mule.module.db.internal.domain.param.InputQueryParam;
import org.mule.module.db.internal.domain.param.OutputQueryParam;
import org.mule.module.db.internal.domain.param.QueryParam;
import org.mule.module.db.internal.domain.query.QueryTemplate;
import org.mule.module.db.internal.domain.query.QueryType;
import org.mule.module.db.internal.domain.type.DbType;
import org.mule.module.db.internal.domain.type.JdbcTypes;
import org.mule.module.db.internal.domain.type.UnknownDbType;
import org.mule.module.db.internal.parser.QueryTemplateParser;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class ParameterizedQueryTemplateFactoryBeanTestCase
extends AbstractMuleTestCase {
    public static final String QUERY = "select * from test";
    public static final String PARAMETERIZED_QUERY = "select * from test where position = :position";
    public static final String PARSED_PARAMETERIZED_QUERY = "select * from test where position = ?";
    public static final String POSITION_PARAM_NAME = "position";
    public static final String TEMPLATE_PARAM_VALUE = "5";
    public static final String OVERRIDDEN_PARAM_VALUE = "10";

    @Test
    public void createsQueryWithNoParams() throws Exception {
        QueryTemplate queryTemplate = new QueryTemplate(QUERY, QueryType.SELECT, Collections.emptyList());
        QueryTemplateParser queryParser = (QueryTemplateParser)Mockito.mock(QueryTemplateParser.class);
        Mockito.when((Object)queryParser.parse(QUERY)).thenReturn((Object)queryTemplate);
        ParameterizedQueryTemplateFactoryBean factoryBean = new ParameterizedQueryTemplateFactoryBean(QUERY, Collections.EMPTY_LIST, queryParser);
        QueryTemplate createdQueryTemplate = factoryBean.getObject();
        MatcherAssert.assertThat((Object)createdQueryTemplate.getSqlText(), (Matcher)IsEqual.equalTo((Object)QUERY));
        MatcherAssert.assertThat((Object)createdQueryTemplate.getType(), (Matcher)IsEqual.equalTo((Object)QueryType.SELECT));
        MatcherAssert.assertThat((Object)createdQueryTemplate.getParams(), (Matcher)Is.is((Matcher)Matchers.empty()));
    }

    @Test
    public void createsQueryWithDefaultParams() throws Exception {
        List<DefaultInputQueryParam> defaultParams = Collections.singletonList(new DefaultInputQueryParam(1, JdbcTypes.INTEGER_DB_TYPE, (Object)TEMPLATE_PARAM_VALUE, POSITION_PARAM_NAME));
        QueryTemplate queryTemplate = new QueryTemplate(PARSED_PARAMETERIZED_QUERY, QueryType.SELECT, defaultParams);
        QueryTemplateParser queryParser = (QueryTemplateParser)Mockito.mock(QueryTemplateParser.class);
        Mockito.when((Object)queryParser.parse(PARAMETERIZED_QUERY)).thenReturn((Object)queryTemplate);
        ParameterizedQueryTemplateFactoryBean factoryBean = new ParameterizedQueryTemplateFactoryBean(PARAMETERIZED_QUERY, Collections.EMPTY_LIST, queryParser);
        QueryTemplate createdQueryTemplate = factoryBean.getObject();
        MatcherAssert.assertThat((Object)createdQueryTemplate.getSqlText(), (Matcher)IsEqual.equalTo((Object)PARSED_PARAMETERIZED_QUERY));
        MatcherAssert.assertThat((Object)createdQueryTemplate.getType(), (Matcher)IsEqual.equalTo((Object)QueryType.SELECT));
        MatcherAssert.assertThat((Object)createdQueryTemplate.getParams().size(), (Matcher)IsEqual.equalTo((Object)1));
        InputQueryParam inputQueryParam = (InputQueryParam)createdQueryTemplate.getInputParams().get(0);
        MatcherAssert.assertThat((Object)inputQueryParam.getValue(), (Matcher)IsEqual.equalTo((Object)TEMPLATE_PARAM_VALUE));
    }

    @Test
    public void createsQueryWithOverriddenParams() throws Exception {
        QueryTemplate createdQueryTemplate = this.doOverriddenParamTest(JdbcTypes.INTEGER_DB_TYPE, (QueryParam)new DefaultInputQueryParam(1, JdbcTypes.INTEGER_DB_TYPE, (Object)OVERRIDDEN_PARAM_VALUE, POSITION_PARAM_NAME));
        MatcherAssert.assertThat((Object)createdQueryTemplate.getSqlText(), (Matcher)IsEqual.equalTo((Object)PARSED_PARAMETERIZED_QUERY));
        MatcherAssert.assertThat((Object)createdQueryTemplate.getType(), (Matcher)IsEqual.equalTo((Object)QueryType.SELECT));
        MatcherAssert.assertThat((Object)createdQueryTemplate.getParams().size(), (Matcher)IsEqual.equalTo((Object)1));
        InputQueryParam inputQueryParam = (InputQueryParam)createdQueryTemplate.getInputParams().get(0);
        MatcherAssert.assertThat((Object)inputQueryParam.getValue(), (Matcher)IsEqual.equalTo((Object)OVERRIDDEN_PARAM_VALUE));
    }

    @Test
    public void overrideInputParamUsingTemplateType() throws Exception {
        this.doInputParamOverrideTest(JdbcTypes.INTEGER_DB_TYPE, UnknownDbType.getInstance(), JdbcTypes.INTEGER_DB_TYPE);
    }

    @Test
    public void overrideInputParamUsingOverriddenType() throws Exception {
        this.doInputParamOverrideTest(UnknownDbType.getInstance(), JdbcTypes.INTEGER_DB_TYPE, JdbcTypes.INTEGER_DB_TYPE);
    }

    @Test
    public void overrideInOutParamUsingTemplateType() throws Exception {
        this.doInOutParamOverrideTest(JdbcTypes.INTEGER_DB_TYPE, UnknownDbType.getInstance(), JdbcTypes.INTEGER_DB_TYPE);
    }

    @Test
    public void overrideInOutParamUsingOverriddenType() throws Exception {
        this.doInOutParamOverrideTest(UnknownDbType.getInstance(), JdbcTypes.INTEGER_DB_TYPE, JdbcTypes.INTEGER_DB_TYPE);
    }

    @Test
    public void overrideOutputParamUsingTemplateType() throws Exception {
        this.doOutputParamOverrideTest(JdbcTypes.INTEGER_DB_TYPE, UnknownDbType.getInstance(), JdbcTypes.INTEGER_DB_TYPE);
    }

    @Test
    public void overrideOutputParamUsingOverriddenType() throws Exception {
        this.doOutputParamOverrideTest(UnknownDbType.getInstance(), JdbcTypes.INTEGER_DB_TYPE, JdbcTypes.INTEGER_DB_TYPE);
    }

    private void doInputParamOverrideTest(DbType templateParamType, DbType overriddenParamType, DbType expectedParamType) throws Exception {
        DefaultInputQueryParam overriddenParam = new DefaultInputQueryParam(2, overriddenParamType, (Object)OVERRIDDEN_PARAM_VALUE, POSITION_PARAM_NAME);
        QueryTemplate createdQueryTemplate = this.doOverriddenParamTest(templateParamType, (QueryParam)overriddenParam);
        MatcherAssert.assertThat((Object)createdQueryTemplate.getParams().size(), (Matcher)IsEqual.equalTo((Object)1));
        InputQueryParam inputQueryParam = (InputQueryParam)createdQueryTemplate.getInputParams().get(0);
        MatcherAssert.assertThat((Object)inputQueryParam.getIndex(), (Matcher)IsEqual.equalTo((Object)1));
        MatcherAssert.assertThat((Object)inputQueryParam.getType(), (Matcher)IsEqual.equalTo((Object)expectedParamType));
        MatcherAssert.assertThat((Object)inputQueryParam.getName(), (Matcher)IsEqual.equalTo((Object)POSITION_PARAM_NAME));
        MatcherAssert.assertThat((Object)inputQueryParam.getValue(), (Matcher)IsEqual.equalTo((Object)OVERRIDDEN_PARAM_VALUE));
    }

    private void doInOutParamOverrideTest(DbType templateParamType, DbType overriddenParamType, DbType expectedParamType) throws Exception {
        DefaultInOutQueryParam overriddenParam = new DefaultInOutQueryParam(2, overriddenParamType, POSITION_PARAM_NAME, (Object)OVERRIDDEN_PARAM_VALUE);
        QueryTemplate createdQueryTemplate = this.doOverriddenParamTest(templateParamType, (QueryParam)overriddenParam);
        MatcherAssert.assertThat((Object)createdQueryTemplate.getParams().size(), (Matcher)IsEqual.equalTo((Object)1));
        InOutQueryParam queryParam = (InOutQueryParam)createdQueryTemplate.getParams().get(0);
        MatcherAssert.assertThat((Object)queryParam.getIndex(), (Matcher)IsEqual.equalTo((Object)1));
        MatcherAssert.assertThat((Object)queryParam.getType(), (Matcher)IsEqual.equalTo((Object)expectedParamType));
        MatcherAssert.assertThat((Object)queryParam.getName(), (Matcher)IsEqual.equalTo((Object)POSITION_PARAM_NAME));
        MatcherAssert.assertThat((Object)queryParam.getValue(), (Matcher)IsEqual.equalTo((Object)OVERRIDDEN_PARAM_VALUE));
    }

    private QueryTemplate doOverriddenParamTest(DbType templateParamType, QueryParam overriddenParam) throws Exception {
        List<DefaultInputQueryParam> defaultParams = Collections.singletonList(new DefaultInputQueryParam(1, templateParamType, (Object)TEMPLATE_PARAM_VALUE, POSITION_PARAM_NAME));
        QueryTemplate queryTemplate = new QueryTemplate(PARSED_PARAMETERIZED_QUERY, QueryType.SELECT, defaultParams);
        QueryTemplateParser queryParser = (QueryTemplateParser)Mockito.mock(QueryTemplateParser.class);
        Mockito.when((Object)queryParser.parse(PARAMETERIZED_QUERY)).thenReturn((Object)queryTemplate);
        List<QueryParam> overriddenParams = Collections.singletonList(overriddenParam);
        ParameterizedQueryTemplateFactoryBean factoryBean = new ParameterizedQueryTemplateFactoryBean(PARAMETERIZED_QUERY, overriddenParams, queryParser);
        return factoryBean.getObject();
    }

    private void doOutputParamOverrideTest(DbType templateParamType, DbType overriddenParamType, DbType expectedParamType) throws Exception {
        DefaultOutputQueryParam overriddenParam = new DefaultOutputQueryParam(2, overriddenParamType, POSITION_PARAM_NAME);
        List<DefaultInputQueryParam> defaultParams = Collections.singletonList(new DefaultInputQueryParam(1, templateParamType, (Object)TEMPLATE_PARAM_VALUE, POSITION_PARAM_NAME));
        QueryTemplate queryTemplate = new QueryTemplate(PARSED_PARAMETERIZED_QUERY, QueryType.SELECT, defaultParams);
        QueryTemplateParser queryParser = (QueryTemplateParser)Mockito.mock(QueryTemplateParser.class);
        Mockito.when((Object)queryParser.parse(PARAMETERIZED_QUERY)).thenReturn((Object)queryTemplate);
        List<DefaultOutputQueryParam> overriddenParams = Collections.singletonList(overriddenParam);
        ParameterizedQueryTemplateFactoryBean factoryBean = new ParameterizedQueryTemplateFactoryBean(PARAMETERIZED_QUERY, overriddenParams, queryParser);
        QueryTemplate createdQueryTemplate = factoryBean.getObject();
        MatcherAssert.assertThat((Object)createdQueryTemplate.getParams().size(), (Matcher)IsEqual.equalTo((Object)1));
        OutputQueryParam queryParam = (OutputQueryParam)createdQueryTemplate.getOutputParams().get(0);
        MatcherAssert.assertThat((Object)queryParam.getIndex(), (Matcher)IsEqual.equalTo((Object)1));
        MatcherAssert.assertThat((Object)queryParam.getType(), (Matcher)IsEqual.equalTo((Object)expectedParamType));
        MatcherAssert.assertThat((Object)queryParam.getName(), (Matcher)IsEqual.equalTo((Object)POSITION_PARAM_NAME));
    }
}

