/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.config.domain.query;

import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.module.db.internal.config.domain.query.QueryFileFactoryBean;
import org.mule.module.db.internal.util.FileReader;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class QueryFileFactoryBeanTestCase
extends AbstractMuleTestCase {
    @Test
    public void createsQueryFromFile() throws Exception {
        String fileName = "file";
        String fileContent = "select * from test";
        FileReader fileReader = (FileReader)Mockito.mock(FileReader.class);
        Mockito.when((Object)fileReader.getResourceAsString(fileName)).thenReturn((Object)fileContent);
        QueryFileFactoryBean factoryBean = new QueryFileFactoryBean(fileName, fileReader);
        String query = factoryBean.getObject();
        MatcherAssert.assertThat((Object)query, (Matcher)CoreMatchers.equalTo((Object)fileContent));
    }

    @Test(expected=IllegalStateException.class)
    public void failsToReadFile() throws Exception {
        String fileName = "file";
        FileReader fileReader = (FileReader)Mockito.mock(FileReader.class);
        Mockito.when((Object)fileReader.getResourceAsString(fileName)).thenThrow(new Throwable[]{new IOException()});
        QueryFileFactoryBean factoryBean = new QueryFileFactoryBean(fileName, fileReader);
        factoryBean.getObject();
    }
}

