/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.domain.type;

import java.io.ByteArrayInputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.module.db.internal.domain.type.BlobResolvedDataType;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class BlobResolvedDataTypeTestCase
extends AbstractMuleTestCase {
    private static final int PARAM_INDEX = 1;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private BlobResolvedDataType dataType;
    private PreparedStatement statement;
    private Connection connection;
    private Blob blob;

    @Before
    public void setUp() throws Exception {
        this.dataType = new BlobResolvedDataType(2004, null);
        this.statement = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        this.connection = (Connection)Mockito.mock(Connection.class);
        this.blob = (Blob)Mockito.mock(Blob.class);
        Mockito.when((Object)this.statement.getConnection()).thenReturn((Object)this.connection);
        Mockito.when((Object)this.connection.createBlob()).thenReturn((Object)this.blob);
    }

    @Test
    public void convertsStringToBlob() throws Exception {
        String value = "foo";
        this.dataType.setParameterValue(this.statement, 1, (Object)value.getBytes());
        ((Blob)Mockito.verify((Object)this.blob)).setBytes(1L, value.getBytes());
        ((PreparedStatement)Mockito.verify((Object)this.statement)).setObject(1, (Object)this.blob, 2004);
    }

    @Test
    public void convertsInputStreamToBlob() throws Exception {
        String streamContent = "bar";
        ByteArrayInputStream value = new ByteArrayInputStream(streamContent.getBytes());
        this.dataType.setParameterValue(this.statement, 1, (Object)value);
        ((Blob)Mockito.verify((Object)this.blob)).setBytes(1L, streamContent.getBytes());
        ((PreparedStatement)Mockito.verify((Object)this.statement)).setObject(1, (Object)this.blob, 2004);
    }

    @Test
    public void failsToConvertUnsupportedType() throws Exception {
        Object value = new Object();
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)BlobResolvedDataType.createUnsupportedTypeErrorMessage((Object)value)));
        this.dataType.setParameterValue(this.statement, 1, value);
    }
}

