/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.domain.type;

import java.util.Arrays;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.domain.type.CompositeDbTypeManager;
import org.mule.module.db.internal.domain.type.DbType;
import org.mule.module.db.internal.domain.type.DbTypeManager;
import org.mule.module.db.internal.domain.type.UnknownDbTypeException;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class CompositeDbTypeManagerTestCase
extends AbstractMuleTestCase {
    public static final int TYPE_ID = 1;
    public static final String TYPE_NAME = "";
    private final DbConnection connection = (DbConnection)Mockito.mock(DbConnection.class);
    private final DbTypeManager dbTypeManager1 = (DbTypeManager)Mockito.mock(DbTypeManager.class);
    private final DbTypeManager dbTypeManager2 = (DbTypeManager)Mockito.mock(DbTypeManager.class);
    private final List<DbTypeManager> typeManagers = Arrays.asList(this.dbTypeManager1, this.dbTypeManager2);
    private final CompositeDbTypeManager composite = new CompositeDbTypeManager(this.typeManagers);
    private final DbType dbType = (DbType)Mockito.mock(DbType.class);

    @Test
    public void lookupsByNameAndId() throws Exception {
        Mockito.when((Object)this.dbTypeManager1.lookup(this.connection, 1, TYPE_NAME)).thenThrow(new Throwable[]{new UnknownDbTypeException(1, TYPE_NAME)});
        Mockito.when((Object)this.dbTypeManager2.lookup(this.connection, 1, TYPE_NAME)).thenReturn((Object)this.dbType);
        DbType lookup = this.composite.lookup(this.connection, 1, TYPE_NAME);
        ((DbTypeManager)Mockito.verify((Object)this.dbTypeManager1)).lookup(this.connection, 1, TYPE_NAME);
        Assert.assertThat((Object)lookup, (Matcher)CoreMatchers.sameInstance((Object)this.dbType));
    }

    @Test(expected=UnknownDbTypeException.class)
    public void failsWhenNoManagerResolvesLookupByNameAndId() throws Exception {
        Mockito.when((Object)this.dbTypeManager1.lookup(this.connection, 1, TYPE_NAME)).thenThrow(new Throwable[]{new UnknownDbTypeException(TYPE_NAME)});
        Mockito.when((Object)this.dbTypeManager2.lookup(this.connection, 1, TYPE_NAME)).thenThrow(new Throwable[]{new UnknownDbTypeException(TYPE_NAME)});
        this.composite.lookup(this.connection, 1, TYPE_NAME);
    }

    @Test
    public void lookupsByName() throws Exception {
        Mockito.when((Object)this.dbTypeManager1.lookup(this.connection, TYPE_NAME)).thenThrow(new Throwable[]{new UnknownDbTypeException(TYPE_NAME)});
        Mockito.when((Object)this.dbTypeManager2.lookup(this.connection, TYPE_NAME)).thenReturn((Object)this.dbType);
        DbType lookup = this.composite.lookup(this.connection, TYPE_NAME);
        ((DbTypeManager)Mockito.verify((Object)this.dbTypeManager1)).lookup(this.connection, TYPE_NAME);
        Assert.assertThat((Object)lookup, (Matcher)CoreMatchers.sameInstance((Object)this.dbType));
    }

    @Test(expected=UnknownDbTypeException.class)
    public void failsWhenNoManagerResolvesLookupByName() throws Exception {
        Mockito.when((Object)this.dbTypeManager1.lookup(this.connection, TYPE_NAME)).thenThrow(new Throwable[]{new UnknownDbTypeException(TYPE_NAME)});
        Mockito.when((Object)this.dbTypeManager2.lookup(this.connection, TYPE_NAME)).thenThrow(new Throwable[]{new UnknownDbTypeException(TYPE_NAME)});
        this.composite.lookup(this.connection, TYPE_NAME);
    }
}

