/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.domain.type;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Struct;
import java.util.ArrayList;
import org.hamcrest.Matcher;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mule.module.db.internal.domain.type.StructDbType;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class StructDbTypeTestCase
extends AbstractMuleTestCase {
    private static final int PARAM_INDEX = 1;
    private static final String TYPE_NAME = "testStruct";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private StructDbType dataType;
    private PreparedStatement statement;
    private Connection connection;
    private Struct struct;

    @Before
    public void setUp() throws Exception {
        this.dataType = new StructDbType(2002, TYPE_NAME);
        this.statement = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        this.connection = (Connection)Mockito.mock(Connection.class);
        this.struct = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)this.statement.getConnection()).thenReturn((Object)this.connection);
    }

    @Test
    public void convertsArrayToStruct() throws Exception {
        Object[] value = new Object[]{"foo", "bar"};
        Mockito.when((Object)this.connection.createStruct(TYPE_NAME, value)).thenReturn((Object)this.struct);
        this.dataType.setParameterValue(this.statement, 1, (Object)value);
        ((PreparedStatement)Mockito.verify((Object)this.statement)).setObject(1, (Object)this.struct, 2002);
    }

    @Test
    public void convertsListToStruct() throws Exception {
        ArrayList<String> value = new ArrayList<String>();
        value.add("foo");
        value.add("bar");
        Mockito.when((Object)this.connection.createStruct((String)Matchers.argThat((Matcher)org.hamcrest.Matchers.equalTo((Object)TYPE_NAME)), (Object[])Matchers.argThat((Matcher)org.hamcrest.Matchers.arrayContaining((Object[])new String[]{"foo", "bar"})))).thenReturn((Object)this.struct);
        this.dataType.setParameterValue(this.statement, 1, value);
        ((PreparedStatement)Mockito.verify((Object)this.statement)).setObject(1, (Object)this.struct, 2002);
    }

    @Test
    public void failsToConvertUnsupportedType() throws Exception {
        Object value = new Object();
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage(org.hamcrest.Matchers.containsString((String)StructDbType.createUnsupportedTypeErrorMessage((Object)value)));
        this.dataType.setParameterValue(this.statement, 1, value);
    }
}

