/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.resolver.database;

import java.sql.SQLException;
import java.util.HashMap;
import javax.sql.DataSource;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.api.MuleEvent;
import org.mule.common.Result;
import org.mule.common.TestResult;
import org.mule.common.metadata.MetaDataKey;
import org.mule.module.db.internal.domain.database.DataSourceConfig;
import org.mule.module.db.internal.domain.database.DataSourceFactory;
import org.mule.module.db.internal.domain.database.DbConfig;
import org.mule.module.db.internal.domain.database.DbConfigFactory;
import org.mule.module.db.internal.resolver.database.DynamicDbConfigResolver;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class DynamicDbConfigResolverTestCase
extends AbstractMuleTestCase {
    @Test
    public void resolvesDbConfig() throws Exception {
        DbConfig expectedDbConfig = (DbConfig)Mockito.mock(DbConfig.class);
        MuleEvent muleEvent = (MuleEvent)Mockito.mock(MuleEvent.class);
        DynamicDbConfigResolver dbConfigResolver = this.createDbConfigFactory(expectedDbConfig);
        DbConfig dbConfig = dbConfigResolver.resolve(muleEvent);
        MatcherAssert.assertThat((Object)dbConfig, (Matcher)Matchers.sameInstance((Object)expectedDbConfig));
    }

    @Test
    public void cachesResolvedDbConfig() throws Exception {
        DbConfig expectedDbConfig = (DbConfig)Mockito.mock(DbConfig.class);
        MuleEvent muleEvent = (MuleEvent)Mockito.mock(MuleEvent.class);
        DynamicDbConfigResolver dbConfigResolver = this.createDbConfigFactory(expectedDbConfig);
        DbConfig dbConfig1 = dbConfigResolver.resolve(muleEvent);
        DbConfig dbConfig2 = dbConfigResolver.resolve(muleEvent);
        MatcherAssert.assertThat((Object)dbConfig1, (Matcher)Matchers.sameInstance((Object)expectedDbConfig));
        MatcherAssert.assertThat((Object)dbConfig1, (Matcher)Matchers.sameInstance((Object)dbConfig2));
    }

    @Test
    public void doesNotTestConnection() throws Exception {
        DbConfig expectedDbConfig = (DbConfig)Mockito.mock(DbConfig.class);
        DynamicDbConfigResolver dbConfigResolver = this.createDbConfigFactory(expectedDbConfig);
        TestResult result = dbConfigResolver.test();
        MatcherAssert.assertThat((Object)result.getStatus(), (Matcher)Matchers.equalTo((Object)Result.Status.FAILURE));
        MatcherAssert.assertThat((Object)result.getMessage(), (Matcher)Matchers.equalTo((Object)"Cannot test connection on a dynamic DB config"));
    }

    @Test
    public void returnsMetaDataKeys() throws Exception {
        DbConfig expectedDbConfig = (DbConfig)Mockito.mock(DbConfig.class);
        DynamicDbConfigResolver dbConfigResolver = this.createDbConfigFactory(expectedDbConfig);
        Result result = dbConfigResolver.getMetaDataKeys();
        MatcherAssert.assertThat((Object)result.getStatus(), (Matcher)Matchers.equalTo((Object)Result.Status.FAILURE));
        MatcherAssert.assertThat((Object)result.getMessage(), (Matcher)Matchers.equalTo((Object)"No metadata obtained"));
    }

    @Test
    public void returnsMetaData() throws Exception {
        DbConfig expectedDbConfig = (DbConfig)Mockito.mock(DbConfig.class);
        DynamicDbConfigResolver dbConfigResolver = this.createDbConfigFactory(expectedDbConfig);
        MetaDataKey metaDataKey = (MetaDataKey)Mockito.mock(MetaDataKey.class);
        Result result = dbConfigResolver.getMetaData(metaDataKey);
        MatcherAssert.assertThat((Object)result.getStatus(), (Matcher)Matchers.equalTo((Object)Result.Status.FAILURE));
        MatcherAssert.assertThat((Object)result.getMessage(), (Matcher)Matchers.equalTo((Object)"No metadata obtained"));
    }

    private DynamicDbConfigResolver createDbConfigFactory(DbConfig expectedDbConfig) throws SQLException {
        String name = "test-dynamic-1";
        DataSourceConfig dataSourceConfig = this.createTestDataSourceConfig();
        DataSource dataSource = (DataSource)Mockito.mock(DataSource.class);
        DataSourceFactory dataSourceFactory = (DataSourceFactory)Mockito.mock(DataSourceFactory.class);
        Mockito.when((Object)dataSourceFactory.create(dataSourceConfig)).thenReturn((Object)dataSource);
        DbConfigFactory dbConfigFactory = (DbConfigFactory)Mockito.mock(DbConfigFactory.class);
        Mockito.when((Object)dbConfigFactory.create(name, new HashMap(), dataSource)).thenReturn((Object)expectedDbConfig);
        return new DynamicDbConfigResolver("test", dbConfigFactory, dataSourceFactory, dataSourceConfig);
    }

    private DataSourceConfig createTestDataSourceConfig() {
        DataSourceConfig dataSourceConfig = new DataSourceConfig(){

            public DataSourceConfig resolve(MuleEvent muleEvent) {
                return this;
            }
        };
        dataSourceConfig.setUrl("url");
        dataSourceConfig.setDriverClassName("driver");
        return dataSourceConfig;
    }
}

