/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.resolver.param;

import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.api.MuleEvent;
import org.mule.api.expression.ExpressionManager;
import org.mule.module.db.internal.domain.query.QueryParamValue;
import org.mule.module.db.internal.resolver.param.AbstractQueryParamResolverTestCase;
import org.mule.module.db.internal.resolver.param.DynamicParamValueResolver;
import org.mule.tck.size.SmallTest;

@SmallTest
public class DynamicParamValueResolverTestCase
extends AbstractQueryParamResolverTestCase {
    private final ExpressionManager expressionManager = (ExpressionManager)Mockito.mock(ExpressionManager.class);
    private final DynamicParamValueResolver paramResolver = new DynamicParamValueResolver(this.expressionManager);

    @Test
    public void resolvesStaticParam() throws Exception {
        String expectedValue = "test";
        List<QueryParamValue> templateParams = this.getQueryParamValues("test");
        List resolvedParams = this.paramResolver.resolveParams(this.muleEvent, templateParams);
        Assert.assertThat((Object)resolvedParams.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((String)((QueryParamValue)resolvedParams.get(0)).getValue()), (Matcher)CoreMatchers.equalTo((Object)"test"));
        ((ExpressionManager)Mockito.verify((Object)this.expressionManager, (VerificationMode)Mockito.times((int)0))).evaluate(Matchers.anyString(), (MuleEvent)Matchers.eq((Object)this.muleEvent));
    }

    @Test
    public void resolvesExpressionParam() throws Exception {
        String expectedParamValue = "foo";
        String paramExpressionValue = "#[payload]";
        this.addResolvableExpression("foo", paramExpressionValue);
        List<QueryParamValue> templateParams = this.getQueryParamValues(paramExpressionValue);
        List resolvedParams = this.paramResolver.resolveParams(this.muleEvent, templateParams);
        Assert.assertThat((Object)resolvedParams.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((String)((QueryParamValue)resolvedParams.get(0)).getValue()), (Matcher)CoreMatchers.equalTo((Object)"foo"));
    }

    @Test
    public void resolvesMultipleParams() throws Exception {
        String expectedParamValue1 = "foo";
        String expectedParamValue2 = "bar";
        String paramExpressionValue = "#[payload]";
        this.addResolvableExpression("foo", paramExpressionValue);
        List<QueryParamValue> templateParams = this.getQueryParamValues(paramExpressionValue, expectedParamValue2);
        List resolvedParams = this.paramResolver.resolveParams(this.muleEvent, templateParams);
        Assert.assertThat((Object)resolvedParams.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((Object)((String)((QueryParamValue)resolvedParams.get(0)).getValue()), (Matcher)CoreMatchers.equalTo((Object)"foo"));
        Assert.assertThat((Object)((String)((QueryParamValue)resolvedParams.get(1)).getValue()), (Matcher)CoreMatchers.equalTo((Object)expectedParamValue2));
    }

    protected void addResolvableExpression(String expectedParamValue, String paramExpressionValue) {
        Mockito.when((Object)this.expressionManager.isExpression(paramExpressionValue)).thenReturn((Object)true);
        Mockito.when((Object)this.expressionManager.evaluate(paramExpressionValue, this.muleEvent)).thenReturn((Object)expectedParamValue);
    }
}

