/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.resolver.param;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.Collections;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.domain.param.DefaultInputQueryParam;
import org.mule.module.db.internal.domain.query.QueryTemplate;
import org.mule.module.db.internal.domain.query.QueryType;
import org.mule.module.db.internal.domain.type.DbTypeManager;
import org.mule.module.db.internal.domain.type.JdbcTypes;
import org.mule.module.db.internal.domain.type.UnknownDbType;
import org.mule.module.db.internal.resolver.param.StoredProcedureParamTypeResolver;
import org.mule.module.db.test.util.DatabaseMetaDataBuilder;
import org.mule.module.db.test.util.DbConnectionBuilder;
import org.mule.module.db.test.util.DbTypeManagerBuilder;
import org.mule.module.db.test.util.StoredProcedureColumnTypesBuilder;
import org.mule.module.db.test.util.TestDbTypeMetadata;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class StoredProcedureParamTypeResolverTestCase
extends AbstractMuleTestCase {
    public static final String TYPE_COLUMN = "type";
    public static final String NAME_COLUMN = "name";

    @Test
    public void resolvesStoredProcedureParamTypes() throws Exception {
        String catalog = "test";
        ResultSet procedureColumns = new StoredProcedureColumnTypesBuilder().with(TestDbTypeMetadata.INTEGER_DB_TYPE_METADATA).build();
        DatabaseMetaData databaseMetaData = new DatabaseMetaDataBuilder().returningStoredProcedureColumns("test", "testStoredProcedure", procedureColumns).build();
        String sqlText = "call testStoredProcedure(?)";
        DbConnection connection = new DbConnectionBuilder().onCalatog("test").with(databaseMetaData).build();
        QueryTemplate queryTemplate = new QueryTemplate("call testStoredProcedure(?)", QueryType.STORE_PROCEDURE_CALL, Collections.singletonList(new DefaultInputQueryParam(1, UnknownDbType.getInstance(), (Object)"7", TYPE_COLUMN)));
        DbTypeManager dbTypeManager = new DbTypeManagerBuilder().on(connection).managing(JdbcTypes.INTEGER_DB_TYPE).build();
        StoredProcedureParamTypeResolver paramTypeResolver = new StoredProcedureParamTypeResolver(dbTypeManager);
        Map parameterTypes = paramTypeResolver.getParameterTypes(connection, queryTemplate);
        Assert.assertThat((Object)parameterTypes.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat(parameterTypes.get(1), (Matcher)CoreMatchers.equalTo((Object)JdbcTypes.INTEGER_DB_TYPE));
    }
}

