/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.resolver.query;

import java.util.Collections;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.domain.param.QueryParam;
import org.mule.module.db.internal.domain.query.Query;
import org.mule.module.db.internal.domain.query.QueryParamValue;
import org.mule.module.db.internal.domain.type.DbType;
import org.mule.module.db.internal.domain.type.JdbcTypes;
import org.mule.module.db.internal.domain.type.UnknownDbType;
import org.mule.module.db.internal.resolver.param.ParamValueResolver;
import org.mule.module.db.internal.resolver.query.AbstractQueryResolverTestCase;
import org.mule.module.db.internal.resolver.query.ParametrizedQueryResolver;
import org.mule.tck.size.SmallTest;

@SmallTest
public class ParametrizedQueryResolverTestCase
extends AbstractQueryResolverTestCase {
    private final Query resolvedTemplateQuery = this.createQuery(this.createQueryTemplate("select * from test", new DbType[]{JdbcTypes.INTEGER_DB_TYPE}), new Object[]{"foo"});
    private final Query unresolvedTemplateQuery = this.createQuery(this.createQueryTemplate("select * from test", new DbType[]{UnknownDbType.getInstance()}), new Object[]{"foo"});

    @Test
    public void resolvesQuery() throws Exception {
        ParamValueResolver paramValueResolver = (ParamValueResolver)Mockito.mock(ParamValueResolver.class);
        ParametrizedQueryResolver queryResolver = new ParametrizedQueryResolver(this.resolvedTemplateQuery, paramValueResolver);
        List<QueryParamValue> resolvedParams = Collections.singletonList(new QueryParamValue("param1", (Object)"foo"));
        Mockito.when((Object)paramValueResolver.resolveParams(this.muleEvent, this.resolvedTemplateQuery.getParamValues())).thenReturn(resolvedParams);
        Query resolvedQuery = queryResolver.resolve(null, this.muleEvent);
        Assert.assertThat((Object)this.resolvedTemplateQuery, (Matcher)IsNot.not((Matcher)IsSame.sameInstance((Object)resolvedQuery)));
        Assert.assertThat((Object)this.resolvedTemplateQuery.getQueryTemplate(), (Matcher)IsSame.sameInstance((Object)resolvedQuery.getQueryTemplate()));
        Assert.assertThat(resolvedParams, (Matcher)IsSame.sameInstance((Object)resolvedQuery.getParamValues()));
        Assert.assertThat((Object)((String)resolvedParams.get(0).getValue()), (Matcher)CoreMatchers.equalTo((Object)"foo"));
    }

    @Test
    public void resolvesQueryWithUnresolvedTemplate() throws Exception {
        ParamValueResolver paramValueResolver = (ParamValueResolver)Mockito.mock(ParamValueResolver.class);
        List<QueryParamValue> resolvedParams = Collections.singletonList(new QueryParamValue("param1", (Object)"foo"));
        Mockito.when((Object)paramValueResolver.resolveParams(this.muleEvent, this.unresolvedTemplateQuery.getParamValues())).thenReturn(resolvedParams);
        ParametrizedQueryResolver queryResolver = new ParametrizedQueryResolver(this.unresolvedTemplateQuery, paramValueResolver);
        DbConnection connection = (DbConnection)Mockito.mock(DbConnection.class);
        Mockito.when((Object)connection.getParamTypes(this.unresolvedTemplateQuery.getQueryTemplate())).thenReturn(Collections.singletonMap(1, JdbcTypes.INTEGER_DB_TYPE));
        Query resolvedQuery = queryResolver.resolve(connection, this.muleEvent);
        Assert.assertThat((Object)this.unresolvedTemplateQuery, (Matcher)IsNot.not((Matcher)IsSame.sameInstance((Object)resolvedQuery)));
        Assert.assertThat((Object)this.unresolvedTemplateQuery.getQueryTemplate().getSqlText(), (Matcher)CoreMatchers.equalTo((Object)resolvedQuery.getQueryTemplate().getSqlText()));
        Assert.assertThat((Object)((QueryParam)resolvedQuery.getQueryTemplate().getParams().get(0)).getType(), (Matcher)CoreMatchers.equalTo((Object)JdbcTypes.INTEGER_DB_TYPE));
        Assert.assertThat(resolvedParams, (Matcher)IsSame.sameInstance((Object)resolvedQuery.getParamValues()));
        Assert.assertThat((Object)((String)resolvedParams.get(0).getValue()), (Matcher)CoreMatchers.equalTo((Object)"foo"));
    }
}

