/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.result.statement;

import java.sql.Statement;
import java.util.Collections;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.module.db.internal.domain.autogeneratedkey.AutoGeneratedKeyStrategy;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.domain.query.QueryTemplate;
import org.mule.module.db.internal.domain.query.QueryType;
import org.mule.module.db.internal.result.resultset.ResultSetHandler;
import org.mule.module.db.internal.result.statement.StatementResult;
import org.mule.module.db.internal.result.statement.StatementResultHandler;
import org.mule.module.db.internal.result.statement.StatementResultIterator;
import org.mule.module.db.internal.result.statement.StatementResultIteratorFactory;
import org.mule.tck.junit4.AbstractMuleTestCase;

public abstract class AbstractStatementResultHandlerTestCase
extends AbstractMuleTestCase {
    private final QueryTemplate queryTemplate = new QueryTemplate("UNUSED", QueryType.SELECT, Collections.emptyList());
    private final AutoGeneratedKeyStrategy autoGeneratedKeyStrategy = (AutoGeneratedKeyStrategy)Mockito.mock(AutoGeneratedKeyStrategy.class);
    private final DbConnection connection = (DbConnection)Mockito.mock(DbConnection.class);
    private final Statement statement = (Statement)Mockito.mock(Statement.class);
    private final ResultSetHandler resultSetHandler = (ResultSetHandler)Mockito.mock(ResultSetHandler.class);
    private final StatementResultHandler statementResultHandler = this.createStatementResultHandler(this.resultSetHandler);
    private final StatementResultIterator statementResultIterator = (StatementResultIterator)Mockito.mock(StatementResultIterator.class);
    private final StatementResultIteratorFactory statementResultIteratorFactory = (StatementResultIteratorFactory)Mockito.mock(StatementResultIteratorFactory.class);

    @Before
    public void setUpStatementResultIteratorFactory() throws Exception {
        Mockito.when((Object)this.statementResultIteratorFactory.create(this.connection, this.statement, this.queryTemplate, this.autoGeneratedKeyStrategy)).thenReturn((Object)this.statementResultIterator);
        Mockito.when((Object)this.connection.getStatementResultIteratorFactory(this.resultSetHandler)).thenReturn((Object)this.statementResultIteratorFactory);
    }

    @Test
    public void processEmptyStatementResults() throws Exception {
        Object statementResults = this.statementResultHandler.processStatement(this.connection, this.statement, this.queryTemplate, this.autoGeneratedKeyStrategy);
        Assert.assertThat((Object)statementResults, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(Map.class)));
        Map mapResults = (Map)statementResults;
        Assert.assertThat((Object)mapResults.size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void processMultipleStatementResults() throws Exception {
        StatementResult result1 = (StatementResult)Mockito.mock(StatementResult.class);
        Mockito.when((Object)result1.getName()).thenReturn((Object)"result1");
        StatementResult result2 = (StatementResult)Mockito.mock(StatementResult.class);
        Mockito.when((Object)result2.getName()).thenReturn((Object)"result2");
        Mockito.when((Object)this.statementResultIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        Mockito.when((Object)this.statementResultIterator.next()).thenReturn((Object)result1, (Object[])new StatementResult[]{result2});
        Object statementResults = this.statementResultHandler.processStatement(this.connection, this.statement, this.queryTemplate, this.autoGeneratedKeyStrategy);
        Assert.assertThat((Object)statementResults, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(Map.class)));
        Map mapResults = (Map)statementResults;
        Assert.assertThat((Object)mapResults.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((Object)mapResults.containsKey("result1"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)mapResults.containsKey("result2"), (Matcher)Is.is((Object)true));
    }

    @Test
    public void closesResourcesIfNeeded() throws Exception {
        this.statementResultHandler.processStatement(this.connection, this.statement, this.queryTemplate, this.autoGeneratedKeyStrategy);
        int expectedTimes = this.mustCloseResources() ? 1 : 0;
        ((Statement)Mockito.verify((Object)this.statement, (VerificationMode)Mockito.times((int)expectedTimes))).close();
        ((DbConnection)Mockito.verify((Object)this.connection, (VerificationMode)Mockito.times((int)expectedTimes))).release();
    }

    protected abstract StatementResultHandler createStatementResultHandler(ResultSetHandler var1);

    protected abstract boolean mustCloseResources();
}

