/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.model;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.common.metadata.datatype.DataType;
import org.mule.module.db.integration.model.Alien;
import org.mule.module.db.integration.model.Contact;
import org.mule.module.db.integration.model.Planet;
import org.mule.module.db.integration.model.Region;
import org.mule.module.db.integration.model.RegionManager;

public abstract class AbstractTestDatabase {
    public static final Planet[] PLANET_TEST_VALUES = new Planet[]{Planet.VENUS, Planet.EARTH, Planet.MARS};
    public static final Alien[] ALIEN_TEST_VALUES = new Alien[]{Alien.MONGUITO, Alien.ET};
    public static final Contact[] CONTACT_TEST_VALUES = new Contact[]{Contact.CONTACT1, Contact.CONTACT2};
    public static final Region[] REGION_TEST_VALUES = new Region[]{Region.NORTHWEST, Region.SOUTHWEST};
    public static final RegionManager[] REGION_MANAGER_TEST_VALUES = new RegionManager[]{RegionManager.SOUTHWEST_MANAGER, RegionManager.NORTHWEST_MANAGER};
    private static final Log logger = LogFactory.getLog(AbstractTestDatabase.class);
    public static final String NO_SQLXML_SUPPORT_ERROR = "Database does not support SQLXML type";
    public static final String NO_RESULSET_FROM_FUNCTION_SUPPORT_ERROR = "Database does not support returning a resultset from a function";
    public static final String NO_UDT_SUPPORT_ERROR = "Database does not support User Defined Data Types";

    public void deletePlanetTable(Connection connection) throws SQLException {
        this.executeUpdate(connection, "DELETE FROM PLANET");
    }

    public abstract void createPlanetTable(Connection var1) throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeDdl(DataSource dataSource, String ddl) throws SQLException {
        try (Connection connection = dataSource.getConnection();){
            AbstractTestDatabase.executeDdl(connection, ddl);
        }
    }

    public static void executeDdl(Connection connection, String ddl) throws SQLException {
        try (Statement statement = connection.createStatement();){
            statement.executeUpdate(ddl);
        }
    }

    public void executeUpdate(Connection connection, String updateSql) throws SQLException {
        try (Statement statement = connection.createStatement();){
            int updated = statement.executeUpdate(updateSql);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(updated + " rows updated"));
            }
        }
    }

    public final void populatePlanetTable(Connection connection, Planet[] testValues) throws SQLException {
        QueryRunner qr = new QueryRunner();
        for (Planet planet : testValues) {
            int updated = qr.update(connection, this.getInsertPlanetSql(planet.getName(), planet.getPosition()));
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)(updated + " rows updated"));
        }
    }

    protected abstract String getInsertPlanetSql(String var1, int var2);

    public void createDefaultDatabaseConfig(DataSource dataSource) throws SQLException {
        try (Connection connection = dataSource.getConnection();){
            connection.setAutoCommit(false);
            this.createPlanetTestTable(connection);
            if (this.supportsXmlType()) {
                this.createAlienTestTable(connection);
            }
            if (this.supportsSimpleUdt()) {
                this.createContactDetailsType(connection);
                this.createRegionManagersTestTable(connection);
                if (this.supportsArraysUdt()) {
                    this.createContactsTestTable(connection);
                    this.createRegionsTestTable(connection);
                }
            }
            connection.commit();
        }
    }

    protected boolean supportsArraysUdt() {
        return false;
    }

    protected boolean supportsSimpleUdt() {
        return false;
    }

    protected void createZipArrayType(Connection connection) throws SQLException {
        throw new UnsupportedOperationException(NO_UDT_SUPPORT_ERROR);
    }

    protected void createContactDetailsType(Connection connection) throws SQLException {
        throw new UnsupportedOperationException(NO_UDT_SUPPORT_ERROR);
    }

    protected void createContactDetailsArrayType(Connection connection) throws SQLException {
        throw new UnsupportedOperationException(NO_UDT_SUPPORT_ERROR);
    }

    private void createContactsTestTable(Connection connection) throws SQLException {
        try {
            this.deleteContactsTable(connection);
        }
        catch (Exception e) {
            this.createContactDetailsArrayType(connection);
            this.createContactsTable(connection);
        }
        this.populateContactsTable(connection, CONTACT_TEST_VALUES);
    }

    private void populateContactsTable(Connection connection, Contact[] contacts) throws SQLException {
        QueryRunner qr = new QueryRunner();
        for (Contact contact : contacts) {
            int updated = qr.update(connection, this.getInsertContactSql(contact));
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)(updated + " rows updated"));
        }
    }

    protected String getInsertContactSql(Contact contact) {
        throw new UnsupportedOperationException(NO_UDT_SUPPORT_ERROR);
    }

    protected void createContactsTable(Connection connection) throws SQLException {
        throw new UnsupportedOperationException(NO_UDT_SUPPORT_ERROR);
    }

    protected void deleteContactsTable(Connection connection) throws SQLException {
        throw new UnsupportedOperationException(NO_UDT_SUPPORT_ERROR);
    }

    protected void createRegionsTestTable(Connection connection) throws SQLException {
        try {
            this.deleteRegionsTable(connection);
        }
        catch (Exception e) {
            this.createZipArrayType(connection);
            this.createRegionsTable(connection);
        }
        this.populateRegionsTable(connection, REGION_TEST_VALUES);
    }

    private void createRegionManagersTestTable(Connection connection) throws SQLException {
        try {
            this.deleteRegionManagersTable(connection);
        }
        catch (Exception e) {
            this.createRegionManagersTable(connection);
        }
        this.populateRegionManagersTable(connection, REGION_MANAGER_TEST_VALUES);
    }

    private void populateRegionsTable(Connection connection, Region[] regions) throws SQLException {
        QueryRunner qr = new QueryRunner();
        for (Region region : regions) {
            int updated = qr.update(connection, this.getInsertRegionSql(region));
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)(updated + " rows updated"));
        }
    }

    protected String getInsertRegionSql(Region region) {
        throw new UnsupportedOperationException(NO_UDT_SUPPORT_ERROR);
    }

    protected void createRegionsTable(Connection connection) throws SQLException {
        throw new UnsupportedOperationException(NO_UDT_SUPPORT_ERROR);
    }

    protected void deleteRegionsTable(Connection connection) throws SQLException {
        throw new UnsupportedOperationException(NO_UDT_SUPPORT_ERROR);
    }

    protected void deleteRegionManagersTable(Connection connection) throws SQLException {
        throw new UnsupportedOperationException(NO_UDT_SUPPORT_ERROR);
    }

    protected void createRegionManagersTable(Connection connection) throws SQLException {
        throw new UnsupportedOperationException(NO_UDT_SUPPORT_ERROR);
    }

    private void populateRegionManagersTable(Connection connection, RegionManager[] managers) throws SQLException {
        QueryRunner qr = new QueryRunner();
        for (RegionManager regionManager : managers) {
            int updated = qr.update(connection, this.getInsertRegionManagerSql(regionManager));
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)(updated + " rows updated"));
        }
    }

    protected String getInsertRegionManagerSql(RegionManager regionManager) {
        throw new UnsupportedOperationException(NO_UDT_SUPPORT_ERROR);
    }

    private void createAlienTestTable(Connection connection) throws SQLException {
        try {
            this.deleteAlienTable(connection);
        }
        catch (Exception e) {
            this.createAlienTable(connection);
        }
        this.populateAlienTable(connection, ALIEN_TEST_VALUES);
    }

    private void populateAlienTable(Connection connection, Alien[] testValues) throws SQLException {
        QueryRunner qr = new QueryRunner();
        for (Alien alien : testValues) {
            int updated = qr.update(connection, this.getInsertAlienSql(alien));
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)(updated + " rows updated"));
        }
    }

    protected void createAlienTable(Connection connection) throws SQLException {
        throw new UnsupportedOperationException(NO_SQLXML_SUPPORT_ERROR);
    }

    protected void deleteAlienTable(Connection connection) throws SQLException {
        this.executeUpdate(connection, "DELETE FROM ALIEN");
    }

    protected String getInsertAlienSql(Alien alien) {
        throw new UnsupportedOperationException(NO_SQLXML_SUPPORT_ERROR);
    }

    protected boolean supportsXmlType() {
        return false;
    }

    protected void createPlanetTestTable(Connection connection) throws SQLException {
        try {
            this.deletePlanetTable(connection);
        }
        catch (Exception e) {
            this.createPlanetTable(connection);
        }
        this.populatePlanetTable(connection, PLANET_TEST_VALUES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createStoredProcedure(DataSource dataSource, String sql) throws SQLException {
        try (Connection connection = dataSource.getConnection();){
            Statement statement = connection.createStatement();
            statement.execute(sql);
        }
    }

    public abstract void createStoredProcedureGetRecords(DataSource var1) throws SQLException;

    public void createFunctionGetRecords(DataSource dataSource) throws SQLException {
        throw new UnsupportedOperationException(NO_RESULSET_FROM_FUNCTION_SUPPORT_ERROR);
    }

    public abstract void createStoredProcedureUpdateTestType1(DataSource var1) throws SQLException;

    public abstract void createStoredProcedureParameterizedUpdateTestType1(DataSource var1) throws SQLException;

    public abstract void createStoredProcedureParameterizedUpdatePlanetDescription(DataSource var1) throws SQLException;

    public abstract void createStoredProcedureCountRecords(DataSource var1) throws SQLException;

    public abstract void createStoredProcedureGetSplitRecords(DataSource var1) throws SQLException;

    public abstract void createStoredProcedureDoubleMyInt(DataSource var1) throws SQLException;

    public abstract void createStoredProcedureMultiplyInts(DataSource var1) throws SQLException;

    public abstract void createStoredProcedureConcatenateStrings(DataSource var1) throws SQLException;

    public abstract void createDelayFunction(DataSource var1) throws SQLException;

    public void createStoredProcedureGetAlienDescription(DataSource dataSource) throws SQLException {
        throw new UnsupportedOperationException(NO_SQLXML_SUPPORT_ERROR);
    }

    public void createStoredProcedureUpdateAlienDescription(DataSource dataSource) throws SQLException {
        throw new UnsupportedOperationException(NO_SQLXML_SUPPORT_ERROR);
    }

    public void createStoredProcedureGetZipCodes(DataSource dataSource) throws SQLException {
        throw new UnsupportedOperationException(NO_UDT_SUPPORT_ERROR);
    }

    public void createStoredProcedureUpdateZipCodes(DataSource dataSource) throws SQLException {
        throw new UnsupportedOperationException(NO_UDT_SUPPORT_ERROR);
    }

    public void createStoredProcedureUpdateContactDetails(DataSource dataSource) throws SQLException {
        throw new UnsupportedOperationException(NO_UDT_SUPPORT_ERROR);
    }

    public void createStoredProcedureGetContactDetails(DataSource dataSource) throws SQLException {
        throw new UnsupportedOperationException(NO_UDT_SUPPORT_ERROR);
    }

    public void createStoredProcedureGetManagerDetails(DataSource dataSource) throws SQLException {
        throw new UnsupportedOperationException(NO_UDT_SUPPORT_ERROR);
    }

    public DataType getIdFieldInputMetaDataType() {
        return DataType.INTEGER;
    }

    public DataType getIdFieldOutputMetaDataType() {
        return DataType.INTEGER;
    }

    public DataType getPositionFieldOutputMetaDataType() {
        return DataType.INTEGER;
    }

    public Class getIdFieldJavaClass() {
        return Number.class;
    }

    public Class getDefaultAutoGeneratedKeyClass() {
        return Number.class;
    }

    public Object getDescriptionFieldOutputMetaDataType() {
        return DataType.POJO;
    }
}

