/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.el;

import java.sql.Struct;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.api.MuleContext;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.el.AbstractDbCreateFunctionTestCase;
import org.mule.module.db.internal.el.AbstractDbFunction;
import org.mule.module.db.internal.el.DbCreateStructFunction;
import org.mule.tck.size.SmallTest;

@SmallTest
public class DbCreateStructFunctionTestCase
extends AbstractDbCreateFunctionTestCase {
    @Test
    public void createsStructFromArray() throws Exception {
        Object[] structValues = new Object[]{"foo", "bar"};
        Object[] params = new Object[]{"dbConfig", "TEST_ARRAY", structValues};
        DbConnection dbConnection = this.createDbConnection(true);
        Struct struct = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)dbConnection.createStruct("TEST_ARRAY", structValues)).thenReturn((Object)struct);
        Object result = this.function.call(params, this.context);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)struct));
    }

    @Test
    public void createsStructFromList() throws Exception {
        Object[] structValues = new Object[]{"foo", "bar"};
        Object[] params = new Object[]{"dbConfig", "TEST_ARRAY", Arrays.asList(structValues)};
        DbConnection dbConnection = this.createDbConnection(true);
        Struct struct = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)dbConnection.createStruct("TEST_ARRAY", structValues)).thenReturn((Object)struct);
        Object result = this.function.call(params, this.context);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)struct));
    }

    @Override
    protected AbstractDbFunction createDbFunction(MuleContext muleContext) {
        return new DbCreateStructFunction(muleContext);
    }
}

